/*
 * CLevel.cpp
 *
 *  Created on: 30 Oct 2023
 *      Author: max.petrak
 */

#include "CLevel.h"

#include "eC_Types.h"
#include "eC_String.h"
#include "GUI.h"
#include "GUIObject.h"
#include "GUITrace.h"
#include "eC_TList_doubleLinked.h"

CLevel::CLevel() :
        m_pkGoal(NULL),
        m_pkObstacles(NULL),
        m_pkDialog(NULL),
        m_pkBall(NULL)
{
    m_iActiveHolesIndex = 0;
    m_kStartingPoint = CGUIPoint(0, 0);
    m_kHoles = eC_TListDoubleLinked<CGUICompositeObject*>();
}

eC_Bool CLevel::SetActiveHolesIndex(eC_Int iHolesIndex, eC_Bool bUpdateVisuals)

{
    if (m_kHoles.GetQuantity() > iHolesIndex)
    {
        if (bUpdateVisuals)
        {
            (*m_kHoles.GetAt(m_iActiveHolesIndex))->SetInvisible(true);
            (*m_kHoles.GetAt(m_iActiveHolesIndex))->InvalidateArea();
            (*m_kHoles.GetAt(iHolesIndex))->SetInvisible(false);
            (*m_kHoles.GetAt(iHolesIndex))->InvalidateArea();
        }
        m_iActiveHolesIndex = iHolesIndex;
        return true;
    }
    GUILOGMESSAGE(
        "CLevel.SetActiveHolesIndex: tried to activate invalid holes");

    return false;
}

eC_Int CLevel::GenerateLevel(ObjectHandle_t eDialogID)
{
    ClearLevel();
    m_pkDialog = GETGUI.GetObjectByID(eDialogID);
    if (NULL != m_pkDialog)
    {
        // Set up level
        m_pkBall = m_pkDialog->GetObjectByID(BALL);
        if (NULL != m_pkBall)
        {
            m_kStartingPoint = m_pkBall->GetRelRect().GetTopLeft();
        }
        else
        {
            m_kStartingPoint = CGUIPoint(0, 0);
        }
        m_pkGoal = m_pkDialog->GetObjectByID(GOAL);
        CGUICompositeObject* pkHoles =
        auto_cast<CGUICompositeObject*>(m_pkDialog->GetObjectByID(HOLES));
        if (NULL != pkHoles)
            m_kHoles.Add(pkHoles);
        m_iActiveHolesIndex = 0;
        m_pkObstacles =
        auto_cast<CGUICompositeObject*>(m_pkDialog->GetObjectByID(OBSTACLES));

        return 0;
    }
    return -1;
}

ObjectHandle_t CLevel::GetDialogID()
{
    if (NULL != m_pkDialog)
    {
        return m_pkDialog->GetID();
    }
    return NO_HANDLE;
}

CGUIPoint CLevel::GetStartingPoint()
{
    return m_kStartingPoint;
}
void CLevel::SetStartingPoint(CGUIPoint kStartingPoint)
{
    m_kStartingPoint = kStartingPoint;
}

eC_Int CLevel::GetActiveHolesIndex()
{
    return m_iActiveHolesIndex;
}

CGUIObject* CLevel::GetBall()
{
    return m_pkBall;
}
void CLevel::SetBall(CGUIObject* pkBall)
{
    m_pkBall = pkBall;
}

CGUIObject* CLevel::GetGoal()
{
    return m_pkGoal;
}
void CLevel::SetGoal(CGUIObject* pkGoal)
{
    m_pkGoal = pkGoal;
}

CGUICompositeObject* CLevel::GetObstacles()
{
    return m_pkObstacles;
}
void CLevel::SetObstacles(CGUICompositeObject* pkObstacles)
{
    m_pkObstacles = pkObstacles;
}

CGUICompositeObject* CLevel::GetCurrentHoles()
{
    return *m_kHoles.GetAt(m_iActiveHolesIndex);
}

// Returns the index of the added holes
eC_Int CLevel::AddHoles(CGUICompositeObject* pkHolesHard)
{
    if (NULL != pkHolesHard)
    {
        m_kHoles.AddAtEnd(pkHolesHard);
        return m_kHoles.GetQuantity()-1;
    }
    return -1;
}

void CLevel::ClearLevel()
{
    m_pkDialog = NULL;
    m_kStartingPoint = CGUIPoint(0, 0);
    m_pkGoal = NULL;
    m_pkObstacles = NULL;
    m_kHoles.RemoveAll();
    m_iActiveHolesIndex = 0;
}

CLevel::~CLevel()
{
    ClearLevel();
    m_kHoles.RemoveAll();
}

CGUICompositeObject& CLevel::GetActiveHoles()
{
    return *(*m_kHoles.GetAt(m_iActiveHolesIndex));
}

void CLevel::HandleCallAPI(const eC_String &kAPI,
    const eC_String kParam)
{

}

