/*
 * CHardware.cpp
 *
 *  Created on: 16 Oct 2023
 *      Author: max.petrak
 */
#ifdef PLATFORM_RENESAS_RZA2M_M13
#include "CHardwareRZA2M.h"

#include "GUITimer.h"

extern "C"
{
#include "m13_rza2m_ek_acc.h"
#include "m13_rza2m_ek_button.h"
}

#include "eC.h"

#include <cstdint>

CHardwareRZA2M::CHardwareRZA2M() :
    CHardware()
{
    // Init accelerometer
    bsp_acc_init();
}

CHardwareRZA2M::~CHardwareRZA2M()
{
}

void CHardwareRZA2M::GetAccelerometerData(eC_Int &iX, eC_Int &iY, eC_Int &iZ)
{
    int16_t vAx = 0;
    int16_t vAy = 0;
    int16_t vAz = 0;

    bsp_acc_get_acc(&vAx, &vAy, &vAz);

    iX = eC_FromInt(vAx);
    iY = eC_FromInt(vAy);
    iZ = eC_FromInt(vAz);
}

eC_Bool CHardwareRZA2M::GetButtonData(eC_Value vButton)
{
    e_r_drv_gpio_level_t eButtonState = GPIO_LEVEL_SC_DEFAULT;
    if (1 == vButton)
    {
        eButtonState = bsp_button_get_state(SW1);
    }
    else if (2 == vButton)
    {
        eButtonState = bsp_button_get_state(SW2);
    }
    switch (eButtonState)
    {
        case GPIO_LEVEL_SC_DEFAULT:
            case GPIO_LEVEL_LOW:
            return true;
            break;
        case GPIO_LEVEL_HIGH:
            return false;
            break;
    }
    return false;
}
#endif
