/*
 * CHardware_RZA2M.cpp
 *
 *  Created on: 16 Oct 2023
 *      Author: max.petrak
 */

#if defined PLATFORM_RENESAS_RA6M3
#include "CHardwareRA6M3.h"

#include "GUICommand.h"

extern "C"
{
#include "m13_ra6m3_ek_acc.h"
#include "m13_ra6m3_ek_switch.h"
}

CHardwareRA6M3::CHardwareRA6M3() :
    CHardware()
{
    bsp_acc_init();
    bsp_switch_io_init();
}

CHardwareRA6M3::~CHardwareRA6M3()
{
}

void CHardwareRA6M3::GetAccelerometerData(eC_Int &iX, eC_Int &iY, eC_Int &iZ)
{
    int16_t vAx = 0;
    int16_t vAy = 0;
    int16_t vAz = 0;

    bsp_acc_get_acc(&vAx, &vAy, &vAz);

    iX = eC_FromInt(vAx);
    iY = eC_FromInt(vAy);
    iZ = eC_FromInt(vAz);
}

eC_Bool CHardwareRA6M3::GetButtonData(eC_Value vButton)
{
    bsp_switch_state_t eButtonState;
    if (1 == vButton)
    {
        eButtonState = bsp_switch_status(BSP_SW1);
    }
    else if (2 == vButton)
    {
        eButtonState = bsp_switch_status(BSP_SW1);
    }
    switch (eButtonState)
    {
    case BSP_SW_NOT_PRESSED:
        return false;
        break;
    case BSP_SW_PRESSED:
        return true;
        break;
    }
    return false;
}
#endif
