/*
 * CHardware.cpp
 *
 *  Created on: 16 Oct 2023
 *      Author: max.petrak
 */

#if defined(eC_TARGET_CPU_X86) || defined(eC_TARGET_CPU_X64)

#include "CHardwareMock.h"
#include "GUITimer.h"

CHardwareMock::CHardwareMock() :
    CHardware(),
    m_bSw1OldState(false),
    m_bSw2OldState(false)
{
}

CHardwareMock::~CHardwareMock()
{
}

void CHardwareMock::GetAccelerometerData(eC_Int &iX, eC_Int &iY, eC_Int &iZ)
{
    iX = m_iX;
    iY = m_iY;
    iZ = m_iZ;

    return;
}

eC_Bool CHardwareMock::GetButtonData(eC_Value vButton)
{
    if (1 == vButton)
    {
        return m_bSw1State;
    }
    else if (2 == vButton)
    {
        return m_bSw2State;
    }
    return false;
}

void CHardwareMock::DoAnimate(const eC_Value &vTimes)
{
    if (true == m_bSw1State)
    {
        if (false == m_bSw1OldState)
        {
            m_pkObserver->OnHardwareChange(1);
            m_bSw1OldState = true;
        }
    }
    else
    {
        m_bSw1OldState = false;
    }
    if (true == m_bSw2State)
    {
        if (false == m_bSw2OldState)
        {
            m_pkObserver->OnHardwareChange(2);
        }
        m_bSw2OldState = true;
    }
    else
    {
        m_bSw2OldState = false;
    }
}

#endif
