/*
 * CLevel.h
 *
 *  Created on: 30 Oct 2023
 *      Author: max.petrak
 */

#ifndef SOURCE_CLEVEL_H_
#define SOURCE_CLEVEL_H_

#include "GUIPoint.h"
#include "GUIObject.h"
#include "GUICompositeObject.h"
#include "eC.h"

class CGUIPoint;
class CGUIObject;
class CGUICompositeObject;
template<class T>
class eC_TListDoubleLinked;
class eC_String;

class CLevel
{
public:
    CLevel();
    ~CLevel();

    CGUIPoint GetStartingPoint();
    void SetStartingPoint(CGUIPoint kStartingPoint);

    CGUIObject* GetGoal();
    void SetGoal(CGUIObject* pkGoal);

    CGUIObject* GetBall();
    void SetBall(CGUIObject* pkBall);

    CGUICompositeObject* GetObstacles();
    void SetObstacles(CGUICompositeObject* pkObstacles);

    CGUICompositeObject* GetCurrentHoles();
    eC_Int AddHoles(CGUICompositeObject* pkHoles);

    ObjectHandle_t GetDialogID();

    void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

    eC_Bool SetActiveHolesIndex(eC_Int iHolesIndex, eC_Bool bUpdateVisuals =
        true);
    eC_Int GetActiveHolesIndex();
    CGUICompositeObject& GetActiveHoles();

    eC_Int GenerateLevel(ObjectHandle_t eDialogHandle);

    void ClearLevel();

protected:
    CGUIObject* m_pkDialog;

private:
    CGUIObject* m_pkBall;
    CGUIPoint m_kStartingPoint;
    CGUIObject *m_pkGoal;
    CGUICompositeObject *m_pkObstacles;
    eC_TListDoubleLinked<CGUICompositeObject*> m_kHoles;
    eC_Int m_iActiveHolesIndex;
};

#endif /* SOURCE_CLEVEL_H_ */
