#include "CustomExtensionFactory.h"

#include "GUIMemLeakWatcher.h"
#include "WindowsLeakWatcher.h"

CustomExtensionFactory* CustomExtensionFactory::ms_pkInstance = NULL;

CustomExtensionFactory::CustomExtensionFactory()
{
}

CustomExtensionFactory::~CustomExtensionFactory()
{
}

CustomExtensionFactory* CustomExtensionFactory::GetInstance()
{
    if (ms_pkInstance == NULL)
    {
        ms_pkInstance = new CustomExtensionFactory();
    }
    return ms_pkInstance;
}

// create-methods
CGUIObject* CustomExtensionFactory::CreateControl(const ControlClassID_t& eControlID)
{
    CGUIObject* pkNewObject = NULL;

    for (eC_UInt index = 0; index < m_kControlVector.GetQuantity(); ++index)
    {
        if (m_kControlVector[index].m_iID == eControlID)
        {
            // call the creation callback to construct this derived type
            pkNewObject = m_kControlVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewObject;
}

CGUIBehaviourDecorator* CustomExtensionFactory::CreateBehaviour(const BehaviourClassID_t& eBehaviourID)
{
    CGUIBehaviourDecorator* pkNewBehaviour = NULL;

    for (eC_UInt index = 0; index < m_kBehaviourVector.GetQuantity(); ++index)
    {
        if (m_kBehaviourVector[index].m_iID == eBehaviourID)
        {
            // call the creation callback to construct this derived type
            pkNewBehaviour = m_kBehaviourVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewBehaviour;
}

CGUICommand* CustomExtensionFactory::CreateCommand(const CommandClassID_t& eCommandID)
{
    CGUICommand* pkNewCommand = NULL;

    for (eC_UInt index = 0; index < m_kCommandVector.GetQuantity(); ++index)
    {
        if (m_kCommandVector[index].m_iID == eCommandID)
        {
            // call the creation callback to construct this derived type
            pkNewCommand = m_kCommandVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewCommand;
}

CGUILayouter* CustomExtensionFactory::CreateLayouter(const LayouterClassID_t& eLayouterID)
{
    CGUILayouter* pkNewLayouter = NULL;

    for (eC_UInt index = 0; index < m_kLayouterVector.GetQuantity(); ++index)
    {
        if (m_kLayouterVector[index].m_iID == eLayouterID)
        {
            // call the creation callback to construct this derived type
            pkNewLayouter = m_kLayouterVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewLayouter;
}

CGUIText* CustomExtensionFactory::CreateText(const TextTypeID_t& eTextType)
{
    CGUIText* pkNewText = NULL;

    for (eC_UInt index = 0; index < m_kTextTypeVector.GetQuantity(); ++index)
    {
        if (m_kTextTypeVector[index].m_iID == eTextType)
        {
            // call the creation callback to construct this derived type
            pkNewText = m_kTextTypeVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewText;
}

#ifdef GUILIANI_ANIMATION_ACTIVE
CGUIAnimation* CustomExtensionFactory::CreateAnimation(const AnimationType_t& eAnimation)
{
    CGUIAnimation* pkNewAnimation = NULL;

    for (eC_UInt index = 0; index < m_kAnimationVector.GetQuantity(); ++index)
    {
        if (m_kAnimationVector[index].m_iID == eAnimation)
        {
            // call the creation callback to construct this derived type
            pkNewAnimation = m_kAnimationVector[index].m_pkCreate();
            break;
        }
    }
    return pkNewAnimation;
}
#endif
