/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __STREAMRUNTIME_CONFIG_H__
#define __STREAMRUNTIME_CONFIG_H__

#include "eC_String.h"

#ifdef GUILIANI_STREAM_GUI
#include "GUIStreamTypes.h"
#endif

#include "GUICommonEnums.h"
#include "GUILayerConfig.h"

/** The NStreamRuntime Namespace contains generic helper classes for initializing a default StreamRuntime application.
The code herein typically remains widely unchanged across most StreamRuntimes.
Feel free to remove these classes from your own application and replace them with custom code, if you wish.*/
namespace NStreamRuntime
{
    /** Helper class for reading the StreamRuntime Configuration from an XML file.
    The configuration does e.g. specifiy the first dialog to show after startup, the initial language file,
    image set, screen resolution etc. */
    class Configurator
    {
        friend class CStreamRuntimeBase;

    public:
        eC_Int GetScreenWidth() const;
        eC_Int GetScreenHeight() const;
        eC_Bool IsWindowResizable() const;

        eC_UInt GetLayerCount() const;
        const LayerConfiguration_t& GetLayerConfig(const eC_UInt& uiLayerIndex);

        const eC_String& GetResourcePathPrefix() const;
        const eC_String& GetImageFileName() const;
        const eC_String& GetFontFileName() const;
        const eC_String& GetSoundFileName() const;
        const eC_String& GetGenResFileName() const;
        const eC_String& GetDataPoolFileName() const;
        const eC_String& GetPropertyFileName() const;
        const eC_String& GetLanguageFileName() const;
        const eC_String& GetAnimationsFileName() const;

        eC_Bool IsBackgroundEnabled() const;
        eC_UInt GetBackgroundColor() const;

        eC_String GetDialogFileName() const;

#ifdef GUILIANI_STREAM_GUI
        FileType_t GetStreamingMode() const;
#endif

        eC_Bool IsProfilingActive() const;
        eC_UInt GetMemoryAvailable() const;
        eC_UInt GetMemoryUsageWarning() const;
        eC_UInt GetMemoryUsageAlert() const;

        CGUICommonEnums::GraphicsWrapper_t GetGfxWrap() const;
        CGUICommonEnums::FontWrapper_t GetFntWrap() const;

        eC_UInt GetFTCacheSize() const;
        eC_UInt GetFTMaxFaces() const;

        eC_UInt GetVersion() const;

    protected:
        Configurator();
        ~Configurator();

        eC_Bool LoadConfiguration(const eC_String& rkFileName);

    private:
        eC_String m_kConfigFileName;
        eC_UInt m_uiVersion;

        eC_Int m_iScreenWidth;
        eC_Int m_iScreenHeight;
        eC_Bool m_bResizable;

        eC_String m_kResourcePathPrefix;
        eC_String m_kAnimationsResFile;
        eC_String m_kImageResFile;
        eC_String m_kFontResFile;
        eC_String m_kSoundResFile;
        eC_String m_kGenResFile;
        eC_String m_kDataPoolFile;
        eC_String m_kPropResFile;
        eC_String m_kLanguageFile;

        eC_Bool m_bBkgEnabled;
        eC_UInt m_uiBkgColor;
        eC_String m_kDialogFile;

#ifdef GUILIANI_STREAM_GUI
        FileType_t m_eStreamingMode;
#endif

        eC_Bool m_bProfilingActive;
        eC_UInt m_uiMemoryAvailable;
        eC_UInt m_uiMemoryUsageWarning;
        eC_UInt m_uiMemoryUsageAlert;

        CGUICommonEnums::GraphicsWrapper_t m_eGfxWrap;
        CGUICommonEnums::FontWrapper_t m_eFntWrap;
        eC_UInt m_uiFTCacheSize;
        eC_UInt m_uiFTMaxFaces;

        eC_TArray<LayerConfiguration_t> m_kLayerConfig;
    };
}

#endif
