#ifndef __GFXENV_RZA2M_H__
#define __GFXENV_RZA2M_H__

#include "GfxEnv.h"

/**
This is the GfxEnv implementation of the graphics wrapper for RA6M3
For details see desription of its base class CGfxEnv.
*/
class CGfxEnvRZA2M : public CGfxEnv
{
public:
    /** Create instance
    @param eSurfaceMode surface-mode
    @param eScreenFormat screen-format
    @param uiWidth width
    @param uiHeight height
    @param uiBufferCount number of buffers
    @param ppkBuffers pointer to buffers
    @param bResizable true if resizable
    @return true if successful
    */
    static eC_Bool CreateInstance(
        const SurfaceMode_t& eSurfaceMode,
        const CGUICommonEnums::ImageType_t& eScreenFormat,
        const eC_UInt& uiWidth,
        const eC_UInt& uiHeight,
        const eC_UInt& uiBufferCount = 1,
        void** ppkBuffers = NULL,
        const eC_Bool& bResizable = false);
        
    virtual eC_Bool RefreshScreen(const CGUIRect& rkInvalidatedArea);
    virtual void EndOfRefresh();

protected:
    /** constructor
    @param eSurfaceMode surface-mode
    @param eScreenFormat screen-format
    @param uiWidth width
    @param uiHeight height
    @param uiBufferCount number of buffers
    @param ppkBuffers pointer to buffers
    @param bResizable true if resizable
    */
    CGfxEnvRZA2M(
        const SurfaceMode_t& eSurfaceMode,
        const CGUICommonEnums::ImageType_t& eScreenFormat,
        const eC_UInt& uiWidth,
        const eC_UInt& uiHeight,
        const eC_UInt& uiBufferCount = 1,
        void** ppkBuffers = NULL,
        const eC_Bool& bResizable = false);

    /** destructor
    */
    virtual ~CGfxEnvRZA2M(void);
};
#endif
