# provide selection-boxes and set definitions for GfxEnv

SET(STREAMRUNTIME_GFXWRAP "EGML" CACHE STRING "use which GfxWrap?")
set_property(CACHE STREAMRUNTIME_GFXWRAP PROPERTY STRINGS EGML BLU GL GLES DAVE DAVEHD)

SET(STREAMRUNTIME_FNTWRAP "FREETYPE" CACHE STRING "use which FntWrap?")
set_property(CACHE STREAMRUNTIME_FNTWRAP PROPERTY STRINGS FREETYPE GLYPHLIB EGML)

SET(STREAMRUNTIME_COLORFORMAT "RGB565" CACHE STRING "use which color-format?")
set_property(CACHE STREAMRUNTIME_COLORFORMAT PROPERTY STRINGS ARGB32 RGB565)

IF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "BLU")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_BLU")
ELSEIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "EGML")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_EGML")
ELSEIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "GL")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_GL")
ELSEIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "GLES")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_EGL")
ELSEIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "DAVE")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_DAVE")
ELSEIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "DAVEHD")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_DAVEHD")
ENDIF("${STREAMRUNTIME_GFXWRAP}" STREQUAL "BLU")

IF("${STREAMRUNTIME_FNTWRAP}" STREQUAL "FREETYPE")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "FNT_USE_FREETYPE")
ELSEIF("${STREAMRUNTIME_FNTWRAP}" STREQUAL "GLYPHLIB")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "FNT_USE_GLYPHLIB")
ELSEIF("${STREAMRUNTIME_FNTWRAP}" STREQUAL "EGML")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "FNT_USE_EGML")
ENDIF("${STREAMRUNTIME_FNTWRAP}" STREQUAL "FREETYPE")

IF("${STREAMRUNTIME_COLORFORMAT}" STREQUAL "ARGB32")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_ARGB32")
ELSEIF("${STREAMRUNTIME_COLORFORMAT}" STREQUAL "RGB565")
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_RGB565")
ENDIF("${STREAMRUNTIME_COLORFORMAT}" STREQUAL "ARGB32")

IF(GUILIANI_USE_SDL2_PLATFORM)
    LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION "GFX_USE_SDL2")
ENDIF(GUILIANI_USE_SDL2_PLATFORM)

LIST(APPEND STREAMRUNTIME_WRAPPER_DEFINITION ${GUILIANI_OGL_VERSION})
