/*
 * Copyright (C) TES Electronic Solutions GmbH,
 * All Rights Reserved.
 * Contact: info@guiliani.de
 *
 * This file is part of the Guiliani HMI framework
 * for the development of graphical user interfaces on embedded systems.
 */

#ifndef _MYGUI_SR_H_
#define _MYGUI_SR_H_

#include "StreamRuntimeGUI.h"
#include "CHardware.h"
#include "CGame.h"

#include "GameState_t.h"

#define GETMYGUI    static_cast<CMyGUI&>(GETGUI)


class CLevel;
class CLevelBase;

// Application specific CGUI instance. Implemented by customer.
class CMyGUI: public NStreamRuntime::CStreamRuntimeGUI, public CGUIObserver, public CHardwareObserver, public CGameObserver
{
public:
    CMyGUI(eC_Value x, eC_Value y, eC_Value width, eC_Value height,
        ObjectHandle_t eID);
   ~CMyGUI();


   virtual void OnNotification(const CGUIValue &kObservedValue,
       const CGUIObject *const pkUpdatedObject, const eC_UInt uiX,
       const eC_UInt uiY);

    /// implementation for simple Application <-> GUI communication
    virtual void DoCallAPI(const eC_String& kAPI, const eC_String& kParam);

    virtual void OnHardwareChange(eC_Int iButton);

    virtual void OnGameStateChange(GameState_t eGameState);

#if defined(eC_TARGET_CPU_X86) || defined(eC_TARGET_CPU_X64)
    eC_Bool DoKeyDown(const GUIKeyIdentifier_t & eKeyIdentifier, const eC_UInt & uiModifiers);

    eC_Bool DoKeyUp(const GUIKeyIdentifier_t & eKeyIdentifier, const eC_UInt & uiModifiers);
#endif

private:
    void SwitchDialog(eC_String kDialogName);
    void InitLevel(ObjectHandle_t eDialogID, eC_Bool bInstantStart = true);

private:
    CLevel* m_pkCurrentLevel;
    CGUICompositeObject* m_pkOverlayDialog;
    eC_Bool m_bOverlayRequested;
    CHardware* m_pkHardware;
    CGame* m_pkGame;
};

#endif //#ifndef _MYGUI_SR_H_
