/*
 * CHardware.h
 *
 *  Created on: 16 Oct 2023
 *      Author: max.petrak
 */

#ifndef SOURCE_CHARDWARE_H_
#define SOURCE_CHARDWARE_H_

#include "eC_Types.h"
#include "eC_TList_doubleLinked.h"

#include "GUISubject.h"
#include "GUIAnimatable.h"

#include "GUITimer.h"

class CHardwareObserver
{
public:
    CHardwareObserver(){}
    virtual ~CHardwareObserver(){}
    virtual void OnHardwareChange(eC_Int iButton){}
};

class CHardware: public CGUIAnimatable
{
public:
    CHardware() :
            m_iX(0),
            m_iY(0),
            m_iZ(0),
            m_bSw1State(false),
            m_bSw2State(false),
            m_iPollingRate(100),
            m_pkObserver(NULL)
    {
        // poll the button states according to the polling rate
        GETTIMER.AddAnimationCallback(m_iPollingRate, this);
    }

    ~CHardware()
    {
    }

    void SetX(eC_Int iX)
    {
        m_iX = iX;
    }
    void SetY(eC_Int iY)
    {
        m_iY = iY;
    }
    void SetZ(eC_Int iZ)
    {
        m_iZ = iZ;
    }
    void SetSw1State(eC_Bool bState)
    {
        m_bSw1State = bState;
    }
    void SetSw2State(eC_Bool bState)
    {
        m_bSw2State = bState;
    }

    void SetObserver(CHardwareObserver* pkObserver)
    {
        m_pkObserver = pkObserver;
    }

    virtual void GetAccelerometerData(eC_Int &iX, eC_Int &iY, eC_Int &iZ) = 0;

    virtual eC_Bool GetButtonData(eC_Value vButton) = 0;

    virtual void DoAnimate(const eC_Value &vTimes)
    {
        // here the polling is happening
        if (GetButtonData(1))
        {
            // m_bSw1State is used for debouncing and only sending a notification once per button press
            if (false == m_bSw1State)
            {
                m_pkObserver->OnHardwareChange(1);
                m_bSw1State = true;
            }
        }
        else
        {
            m_bSw1State = false;
        }
        if (GetButtonData(2))
        {
            // m_bSw2State is used for debouncing and only sending a notification once per button press
            if (false == m_bSw2State)
            {
                m_pkObserver->OnHardwareChange(2);
            }
            m_bSw2State = true;
        }
        else
        {
            m_bSw2State = false;
        }
    }


protected:
    CHardwareObserver* m_pkObserver;
    eC_Int m_iPollingRate;

    eC_Int m_iX;
    eC_Int m_iY;
    eC_Int m_iZ;

    eC_Bool m_bSw1State;
    eC_Bool m_bSw2State;

};

#endif /* SOURCE_CHARDWARE_H_ */
