/*******************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
* Copyright (C) 2012 - 2015 Renesas Electronics Corporation. All rights reserved.
*******************************************************************************/
/***********************************************************************
* File: from_Cpp.cpp
*    Callback function from C++ runtime library.
*
* - $Rev: $
* - $Date:: 2017-01-17T15:08:51+09:00$
************************************************************************/

#if 1

extern "C" {
#include "FreeRTOS.h"
#include <stdlib.h>

}

#include "eC_Platform.h"
#include "GUIConfigDebug.h"

#include <new>


static int heap_inited = 0;
static void* start_addr = NULL;
static void* end_addr = NULL;

void* Malloc(eC_UInt size)
{
    void* p = NULL;
    if (xPortGetFreeHeapSize() != 0)
    {
        p=pvPortMalloc(size);
        if (p==0) // did pvPortMalloc succeed?
        {
            //throw std::bad_alloc(); // ANSI/ISO compliant behavior
        }

        if (heap_inited == 0)
        {
            start_addr = p;
            end_addr = (void*)((uint8_t*)start_addr + configTOTAL_HEAP_SIZE);
            heap_inited = 1;
        }
    }
    else
    {
        p = malloc(size);
    }

    return p;
}

void Free(void* p)
{
    if ((NULL != start_addr) && (p >= start_addr) && (p < end_addr))
        vPortFree(p);
    else
        free(p);
}

/***********************************************************************
* Function: operator new
************************************************************************/

void *operator new (size_t size)
{
    return Malloc(size);
}

/***********************************************************************
* Function: operator delete
************************************************************************/
#ifndef GUILIANI_LEAK_DETECTION
// causes a duplicate definition
void operator delete (void *p)
{
    Free(p);
}
#endif
/***********************************************************************
* Function: operator new []
************************************************************************/

void *operator new [](size_t size)
{
    return Malloc(size);
}

/***********************************************************************
* Function: operator delete []
************************************************************************/

#ifndef GUILIANI_LEAK_DETECTION
// causes a duplicate definition
void operator delete[] (void *p)
{
    Free(p);
}
#endif

/***********************************************************************
* Variable: __dso_handle
*    C++ ABI - DSO Object Destruction API.
************************************************************************/
//unsigned /* uint32_t*/  __dso_handle;

#else

extern "C"
{
#include <stdlib.h>
}

#include "eC_Platform.h"
#include "GUIConfigDebug.h"

#ifdef GUILIANI_REDEFINE_NEW_DELETE

#include "eC_MemLeakDetection.h"
#include "GUIMemLeakFunctions.h"

#include <new>

static int heap_inited = 1;
static void* start_addr = NULL;
static void* end_addr = NULL;

void* Malloc(eC_UInt size)
{
    void* p = NULL;
    if (heap_inited)
    {
        p = Guiliani_new(size, NULL, 0, NULL);
    }
    else
    {
        p = malloc(size);
    }

    return p;
}

void* MallocArray(eC_UInt size)
{
    void* p = NULL;
    if (heap_inited)
    {
        p = Guiliani_newArray(size, NULL, 0, NULL);
    }
    else
    {
        p = malloc(size);
    }

    return p;
}

void Free(void* p)
{
    if (heap_inited)
    {
        Guiliani_delete(p, NULL, 0, NULL);
    }
    else
    {
        free(p);
    }
}

void FreeArray(void* p)
{
    if (heap_inited)
    {
        Guiliani_deleteArray(p, NULL, 0, NULL);
    }
    else
    {
        free(p);
    }
}

/***********************************************************************
* Function: operator new
************************************************************************/

void *operator new (size_t size)
{
    return Malloc(size);
}

/***********************************************************************
* Function: operator delete
************************************************************************/
// causes a duplicate definition
void operator delete (void *p)
{
    Free(p);
}

/***********************************************************************
* Function: operator new []
************************************************************************/

void *operator new [](size_t size)
{
    return MallocArray(size);
}

/***********************************************************************
* Function: operator delete []
************************************************************************/

// causes a duplicate definition
void operator delete[] (void *p)
{
    FreeArray(p);
}

/***********************************************************************
* Variable: __dso_handle
*    C++ ABI - DSO Object Destruction API.
************************************************************************/
//unsigned /* uint32_t*/  __dso_handle;

#endif

#endif
