#include "main_thread.h"
#include "common_data.h"

extern "C"
{
#include "m13_ra6m3_ek_config.h"
#include "m13_ra6m3_ek_led.h"
#include "m13_ra6m3_ek_vcom.h"
#include "m13_ra6m3_ek_touch.h"
#include "m13_ra6m3_ek_lcd.h"
#include "m13_ra6m3_ek_qspi.h"
#include "m13_ra6m3_ek_sdram.h"

#include <stdarg.h>

#if 1
volatile int stack_overflow_count = 0;
void vApplicationStackOverflowHook( TaskHandle_t xTask, char * pcTaskName)
{
    stack_overflow_count++;
}
#endif

// External task definitions
extern void touch_task(void *pvParameters);

extern int vfprintf_custom(void *out, const char *format, va_list args);

int printf(const char * sFormat, ...)
{
    vTaskSuspendAll();
    int r;
    va_list ParamList;

    va_start(ParamList, sFormat);
    r = vfprintf_custom(stderr, sFormat, ParamList);
    va_end(ParamList);

    xTaskResumeAll();

    return r;
}

}

SemaphoreHandle_t i2c_channel_0_semaphore;

extern void GuilianiStart();
extern void GraphicInit();
extern void GraphicTest();

/* pvParameters contains TaskHandle_t */
void main_thread_entry(void *pvParameters)
{
    portBASE_TYPE status;
    TaskHandle_t task;

    //Initialize UART for debug
    bsp_vcom_init();

    // Open SCI channel 4
    bsp_vcom_open(BSP_VCOM_CHANNEL_4);

    // Configure the led pins
    bsp_led_io_init();

    // Create Mutex for I2C channel 0 access
    i2c_channel_0_semaphore = xSemaphoreCreateMutex();

    // Configure i2c0 pins
    bsp_i2c_init(BSP_I2C_CHANNEL_0);

    // Init touch
    bsp_touch_init();

    // Init QSPI
    bsp_qspi_init();

    // Create Touch task
    status = xTaskCreate(touch_task, "Touch Task", 16384, NULL, 1, &task);
    if( status != pdPASS )
    {
        printf("Could not create Touch Task \r\n");
    }

#if 0
    fsp_err_t err = setup_qspi();
    if (err == FSP_SUCCESS)
    {
        printf("qspi init success\r\n");
    }
    else
    {
        printf("qspi init failed\r\n");
    }
#endif

    GraphicInit();

    //GraphicTest();

    GuilianiStart();

    while (1)
    {
        vTaskDelay (1);
    }
}
