/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

/******************************************************************************
 Includes   <System Includes> , "Project Includes"
 ******************************************************************************/

#include <main_thread.h>
#include <stdint.h>

#include "r_glcdc.h"

extern "C"
{
#include "m13_ra6m3_ek_led.h"
#include "m13_ra6m3_ek_vcom.h"
#include "m13_ra6m3_ek_adc.h"
#include "m13_ra6m3_ek_acc.h"
#include "m13_ra6m3_ek_ethernet.h"
#include "m13_ra6m3_ek_touch.h"
#include "m13_ra6m3_ek_lcd.h"

// External task definitions
extern void ethernet_task(void *parameters);
extern void accelerometer_task(void *parameters);
extern void adc_task(void *parameters);
extern void lcd_task(void *parameters);
extern void touch_task(void *pvParameters);
extern void audio_task(void *pvParameters);

// framebuffer for D/AVE is placed in SDRAM
extern uint8_t lcd_fb_background [BSP_LCD_MAX_FRAME_BUFFER] [DISPLAY_BUFFER_STRIDE_BYTES_INPUT0 * 272];
// LCD-buffer is placed in SRAM
uint8_t screenbuffer[DISPLAY_BUFFER_STRIDE_BYTES_INPUT0 * 272] BSP_ALIGN_VARIABLE(64) BSP_PLACE_IN_SECTION(".bss");

extern glcdc_instance_ctrl_t g_display_ctrl;
extern const display_cfg_t g_display_cfg;
}

#define LCD_BYTES_PER_PIXEL (DISPLAY_BITS_PER_PIXEL_INPUT0 >> 3)

#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    extern volatile uint8_t ucHeap[ configTOTAL_HEAP_SIZE ];
#endif

/******************************************************************************
 Private global variables and functions
 ******************************************************************************/

/******************************************************************************
 Imported global variables and functions (from other files)
 ******************************************************************************/

extern d2_device *d2_handle0;

d2_device ** _d2_handle_guiliani = &d2_handle0;

uint8_t BytesPerPixel = LCD_BYTES_PER_PIXEL;
uint16_t m_uiWidth = LCD_WIDTH;
uint16_t m_uiHeight = LCD_HEIGHT;

volatile uint8_t *RZAFrameBuffers[] =
{
     lcd_fb_background[0],
     lcd_fb_background[0]
};

int fb_index = 0;

volatile uint8_t* GetFrameBuffer()
{
    return RZAFrameBuffers[fb_index];
}

extern "C" void FlipFramebuffer()
{
    vsync_wait();

    R_GLCDC_BufferChange(
        &g_display_ctrl,
        (uint8_t*)screenbuffer,
        DISPLAY_FRAME_LAYER_1
    );

    //vsync_wait();


    // copy contents of currently displayed buffer to new draw-buffer
//    uint8_t new_index = (fb_index + 1) % 2;
//    memcpy(lcd_fb_background[new_index], lcd_fb_background[fb_index], LCD_WIDTH * LCD_HEIGHT * LCD_BYTES_PER_PIXEL);

//    fb_index = new_index;
}

extern "C" void CopyBuffer(int iX1, int iY1, int iRectWidth, int iRectHeight)
{
    uint8_t* pubSource = lcd_fb_background[fb_index] + (iY1 * m_uiWidth + iX1) * BytesPerPixel;
    uint8_t* pubDest = screenbuffer + (iY1 * m_uiWidth + iX1) * BytesPerPixel;
    for (uint16_t iLineIndex = 0; iLineIndex < iRectHeight; ++iLineIndex)
    {
        memcpy(pubDest, pubSource, iRectWidth * BytesPerPixel);

        pubSource += m_uiWidth * BytesPerPixel;
        pubDest += m_uiWidth * BytesPerPixel;
    }

    FlipFramebuffer();
}

void GraphicTest()
{
    uint8_t color = 0;

    while(1)
    {
        memset((void*)screenbuffer, color, LCD_WIDTH * LCD_HEIGHT * LCD_BYTES_PER_PIXEL);
        color += 0x12;

        vsync_wait();

        R_GLCDC_BufferChange(
            &g_display_ctrl,
            (uint8_t*)screenbuffer,
            DISPLAY_FRAME_LAYER_1
        );

        vsync_wait();
    }
}

void GraphicInit()
{
    bsp_lcd_io_init();

    fb_index = 0;

    memset((void*)screenbuffer, 0x3e, LCD_WIDTH * LCD_HEIGHT * LCD_BYTES_PER_PIXEL);
    memset((void*)RZAFrameBuffers[0], 0xff, LCD_WIDTH * LCD_HEIGHT * LCD_BYTES_PER_PIXEL);
    memset((void*)RZAFrameBuffers[1], 0x88, LCD_WIDTH * LCD_HEIGHT * LCD_BYTES_PER_PIXEL);

    bsp_lcd_init();
    bsp_lcd_display_on();

    bsp_lcd_set_backlight((bsp_io_level_t)1);

    bsp_lcd_enable_double_buffer();

    bsp_lcd_set_display_buffer(fb_index);

    R_GLCDC_BufferChange(
        &g_display_ctrl,
        (uint8_t*)screenbuffer,
        DISPLAY_FRAME_LAYER_1
    );
}

extern "C" void* GetHeapStart()
{
#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    return (void*)&ucHeap[0];
#else
    #error "no heap allocated"
    return NULL;
#endif
}

extern "C" void* GetHeapEnd()
{
#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    return (void*)((uint8_t*)&ucHeap[0] + configTOTAL_HEAP_SIZE);
#else
    #error "no heap allocated"
    return NULL;
#endif
}

extern "C" void PrintString(const char* message)
{
    PRINTF_INFO(message);
}