/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

extern "C"
{
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
}

// Standard Headers
#include <new>
#include <string.h>

// Guiliani Headers
#include "GUIConfigDebug.h"
#include "MyGUI_SR.h"
#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "StreamRuntimeConfig.h"
#include "StreamRuntimeStartup.h"

#include "GUIInputMedia.h"
#include "GUIEvent.h"

//#include "Resources_RADEMO.h"

#include "GUIMemLeakDetection.h"

// Mem leak watcher need to be last
#include "GUIMemLeakWatcher.h"

/*
 * QSPI_FLASH_START = 0x60000000;
 * QSPI_FLASH_LENGTH = 0x4000000;
 */
#define resource_size 0x4000000

extern "C"
{
// that's the name of the section in the linker-script
extern const uint8_t __attribute__ ((section (".qspi_flash"))) __qspi_flash_start__[resource_size];
const uint8_t* __guilianiResources = __qspi_flash_start__;
}

void GuilianiStart()
{
    GUI_REG_STDOUT_TRACE();

    GUILOG(GUI_TRACE_DEBUG, "CMyGUI::Init: RESOURCE FILE ACTIVE!\n");

    // use a resource file containing all required images, fonts, texts etc.
    GETRESHANDLER.SetResourceData(__guilianiResources);
    //GETRESHANDLER.SetResourceData(GUIResourceData);

    // Use CGUI::SetGuilianiLicenseKey("<ENTER YOUR CODE HERE>")) to set your Guiliani license key via code.
    // Alternatively use CGUI::LoadGuilianiLicenseKey("GuilianiLicense.key") to read your Guiliani license key from a file.

    NStreamRuntime::CStreamRuntimeStartup kStreamRuntime;

    try
    {
        // Load configuration (e.g. ScreenSize, initial Dialog etc.) from file
        if (kStreamRuntime.LoadConfiguration() == false)
        {
            return;
        }

        kStreamRuntime.ConstructWrapperClasses();

		kStreamRuntime.CreateGUI();
    }
    catch (...)
    {
        GUILOG( GUI_TRACE_ERROR, "An unrecoverable error occurred. Executing clean shutdown. \n");
    }

    kStreamRuntime.DestructWrapperClasses();

    GUILOG(GUI_TRACE_DEBUG, "Guiliani shutdown complete.\n");
}

