/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

#include "StreamRuntimeStartup.h"

#include "GUIConfigDebug.h"

#include "MyGUI_SR.h"
#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "GUIImageCache.h"
#include "StreamRuntimeConfig.h"

// Graphic and Font Wrapper
#include "GfxEnvRA6M3.h"

#if defined GFX_USE_EGML
    #include "GfxWrapeGML.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeType.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLib.h"
    #endif
#elif defined GFX_USE_DAVE
    #if defined PLATFORM_RENESAS_RA6M3
        #include "GfxWrapDave.h"
    #endif

    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeDave.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibDave.h"
    #endif
#elif defined GFX_USE_BLU
    #include "GfxWrapBLU.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeType.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLib.h"
    #endif
#else
    #include "GfxWrapNull.h"
#endif

#include "FntWrapNull.h"

// Sound Wrapper
#include "SndWrapNull.h"

// Input Wrapper
#if defined PLATFORM_RENESAS_RA6M3
    #include "GUIInputRA6M3.h"
#else
    #include "GUIInputExample.h"
#endif

#include "GUIException.h"

// Memory Leak Detection
#include "GUIMemLeakWatcher.h"

extern volatile uint8_t* RZAFrameBuffers[];

namespace NStreamRuntime
{
  void CStreamRuntimeStartup::ConstructWrapperClasses()
  {
    /* Sets the graphics and font wrapper */
    try
    {
        CGfxEnvRA6M3::CreateInstance(CGfxEnv::SM_FRAMEBUFFER, CGUICommonEnums::RGB_565, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 1, (void**)RZAFrameBuffers);
#if defined GFX_USE_DAVE
#if defined PLATFORM_RENESAS_RA6M3
        CGfxWrapDAVE::CreateInstance(&GETGFXENV);
#endif
#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeDAVE::CreateInstance(1024 * 1024);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibDAVE::CreateInstance();
#endif
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate graphics wrapper.\n");
    }

    // Sets the sound wrapper
    try
    {
      CSndWrapNull::CreateInstance();
    }
    catch (...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate sound wrapper.\n");
    }

    // Set pointer to resource file handler instance
    try
    {
#if defined PLATFORM_RENESAS_RA6M3
      CGUIInputRA6M3::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 4);
#else
      CGUIInputExample::CreateInstance();
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not create input media.\n");
    }
    GETRESHANDLER.SetResourcePathPrefix("./");
  }
}
