#include "CallApplicationAPICmd.h"

#include "CustomExtensionFactory.h"

#if defined(STREAMRUNTIME_APPLICATION)
#include "GUI.h"
#endif

#ifdef GUILIANI_STREAM_GUI
#include "GUIStreamReader.h"
#endif

#ifdef GUILIANI_WRITE_GUI
#include "GUIStreamWriter.h"
#include "GUICommandResource.h"
#endif

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

#define CALLAPPLICATIONAPICMD_VERSION 1

static const eC_Int CMD_CALLAPPLICATION_UID = 10002;

eC_Bool CallApplicationAPICmd::ms_bInitialized = GETEXTENSIONSFACTORY->RegisterCommand(CommandDescriptor(CMD_CALLAPPLICATION_UID, "CallApplicationAPI", CallApplicationAPICmd::Create));

CallApplicationAPICmd::CallApplicationAPICmd()
{
    SetXMLTag("CallApplicationAPICmd");
}

void CallApplicationAPICmd::Do()
{
#if defined(STREAMRUNTIME_APPLICATION)
    // This the CallApplicationAPI method in MyGUI.
    // Feel free to extend CallApplicationAPI as required.
    GETGUI.DoCallAPI(m_kAPI, m_kParam);
#endif
}

#if defined(GUILIANI_STREAM_GUI)
void CallApplicationAPICmd::ReadFromStream()
{
    const eC_UInt cuiVersion = ReadStreamingHeader(CALLAPPLICATIONAPICMD_VERSION);

    if (cuiVersion <= 1)
    {
        m_kAPI = GETINPUTSTREAM.READ_STRING("ApplicationAPI");
        m_kParam = GETINPUTSTREAM.READ_STRING("Parameter");
        CGUICommand::ReadFromStream();
    }
}
#endif

#if defined(GUILIANI_WRITE_GUI)
void CallApplicationAPICmd::WriteToStream(const eC_Bool bWriteClassID)
{
    WriteStreamingHeader(bWriteClassID, XMLTAG_COMMANDCLASSID, CMD_CALLAPPLICATION_UID, CALLAPPLICATIONAPICMD_VERSION);

    GETOUTPUTSTREAM.WriteString(m_kAPI, "ApplicationAPI");
    GETOUTPUTSTREAM.WriteString(m_kParam, "Parameter");

    // base-class is read after attributes due to additional commands
    CGUICommand::WriteToStream();

    WriteStreamingFooter(bWriteClassID);
}
#endif
