#ifndef __GFXENV_RA6M3_H__
#define __GFXENV_RA6M3_H__

#include "GfxEnv.h"

/**
This is the GfxEnv implementation of the graphics wrapper for RA6M3
For details see desription of its base class CGfxEnv.
*/
class CGfxEnvRA6M3 : public CGfxEnv
{
public:
    /** Create instance
    @param eSurfaceMode surface-mode
    @param eScreenFormat screen-format
    @param uiWidth width
    @param uiHeight height
    @param uiBufferCount number of buffers
    @param ppkBuffers pointer to buffers
    @param bResizable true if resizable
    @return true if successful
    */
    static eC_Bool CreateInstance(
        const SurfaceMode_t& eSurfaceMode,
        const CGUICommonEnums::ImageType_t& eScreenFormat,
        const eC_UInt& uiWidth,
        const eC_UInt& uiHeight,
        const eC_UInt& uiBufferCount = 1,
        void** ppkBuffers = NULL,
        const eC_Bool& bResizable = false);
        
    virtual eC_Bool RefreshScreen(const CGUIRect& rkInvalidatedArea);
    virtual void EndOfRefresh();

protected:
    /** constructor
    @param eSurfaceMode surface-mode
    @param eScreenFormat screen-format
    @param uiWidth width
    @param uiHeight height
    @param uiBufferCount number of buffers
    @param ppkBuffers pointer to buffers
    @param bResizable true if resizable
    */
    CGfxEnvRA6M3(
        const SurfaceMode_t& eSurfaceMode,
        const CGUICommonEnums::ImageType_t& eScreenFormat,
        const eC_UInt& uiWidth,
        const eC_UInt& uiHeight,
        const eC_UInt& uiBufferCount = 1,
        void** ppkBuffers = NULL,
        const eC_Bool& bResizable = false);

    /** destructor
    */
    virtual ~CGfxEnvRA6M3(void);
};
#endif
