#ifndef __GUIINPUT_RA6M3_H__
#define __GUIINPUT_RA6M3_H__

extern "C"
{
    #include "touch_gslX680.h"
}

#include "eC_Semaphore.h"
#include "eC_Types.h"
#include "eC_TList_doubleLinked.h"
#include "GUIInputMedia.h"
#include "GUIEvent.h"

/** this class is used for the input-device on the RA6M3
*/
class CGUIInputRA6M3 : public CGUIInputMedia
{
public:
    /**
        Singleton for creating an input object and change the pointer in
        base class to input window.
        @param iTouchScreenX
        @param iTouchScreenY
        @param iTouchScreenWidth
        @param iTouchScreenHeight
        @param iTouchFilterDelta
     */
    static void CreateInstance(
        const eC_Int& iTouchScreenX,
        const eC_Int& iTouchScreenY,
        const eC_Int& iTouchScreenWidth,
        const eC_Int& iTouchScreenHeight,
        const eC_Int& iTouchFilterDelta);

    virtual CGUIEvent* GetEvent(eC_UInt uiIdleTime);
    
    /** add a new event
    @param kTouchEvent
    */
    void AddEvent(touchevent_data_t kTouchEvent);

protected:
    /** constructor
        @param iTouchScreenX
        @param iTouchScreenY
        @param iTouchScreenWidth
        @param iTouchScreenHeight
        @param iTouchFilterDelta
    */
    CGUIInputRA6M3(
        const eC_Int& iTouchScreenX,
        const eC_Int& iTouchScreenY,
        const eC_Int& iTouchScreenWidth,
        const eC_Int& iTouchScreenHeight,
        const eC_Int& iTouchFilterDelta);

    /** destructor
    */
    ~CGUIInputRA6M3();

private:
    /**
        Copy-constructor.
        @param kSource Source object to be copied.
     */
    CGUIInputRA6M3(const CGUIInputRA6M3& kSource) {}

    /**
        Operator= method.
        @param kSource Source object to be copied.
        @return This instance.
     */
    CGUIInputRA6M3& operator=(const CGUIInputRA6M3& kSource) {return *this;}
    
private:
    eC_Semaphore m_kSemaphore;
    eC_TListDoubleLinked<touchevent_data_t> m_kEventQueue;
    
    touchevent_data_t m_kLastEvent;  
    eC_Bool m_bEventReady;

    eC_Int m_iTouchScreenX;
    eC_Int m_iTouchScreenY;
    eC_Int m_iTouchScreenWidth;
    eC_Int m_iTouchScreenHeight;
    eC_Int m_iTouchFilterDelta;
    
    touchevent_data_t m_eLastTouchEvent;
    
    eC_Int m_iLastPositionX;
    eC_Int m_iLastPositionY;

    eC_Int m_iLastDraggedX;
    eC_Int m_iLastDraggedY;
};
#endif
