
#
# FreeRTOS-GNU-arm-ra6m3_m13 specific settings
#

# set outputs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES RUNTIME_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Binary/${CMAKE_SYSTEM_NAME}/${CMAKE_PLATFORM_NAME}/${CMAKE_CXX_COMPILER_ID}/${CMAKE_BUILD_TYPE}")

FILE(GLOB PLATFORM_COMMON_RA_CPP "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/StreamRuntimeStartup.cpp")
FILE(GLOB PLATFORM_RA_CPP
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/main_thread_entry.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/new_delete.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/StreamRuntime_RA6M3.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/StreamRuntime_RA6M3_Graphic.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/GUIInputRA6M3.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/RA6M3_M13/GfxEnvRA6M3.cpp"
)

SET(PLATFORM_FILES 
    ${PLATFORM_RA_CPP}
    ${PLATFORM_COMMON_RA_CPP}
    ${SYSCALLS_C}
)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PROJECT_SOURCE_DIR}/Common/Include/Platform/RA6M3_M13"
)

IF(GUILIANI_ADD_EGML_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
  )
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE"
  )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

IF(GUILIANI_ADD_GLYPHLIB_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GLYPHLIB}/Include"
  )
ENDIF(GUILIANI_ADD_GLYPHLIB_PLATFORM)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/ra_cfg/aws"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/ra_cfg/driver"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/ra_cfg/fsp_cfg"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/ra_cfg/fsp_cfg/bsp"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/m13design"
  PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/src/m13design/font"
)

IF(STREAMRUNTIME_SDK_PROJECT)
  # Some platform depenant include directories.
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Include/eGML"
    PRIVATE "${PATH_EGAC}/Include/eGML/eGML_RZA1H"
    PRIVATE "${PATH_EGAC}/Include/eDBG"
    PRIVATE "${PATH_EGAC}/Include/eC/FreeRTOS"
    PRIVATE "${PATH_EGAC}/Include/eC/RZA1H"
    PRIVATE "${PATH_LIBS}/freetype/include"
    PRIVATE "${PATH_LIBS}/freetype/include/freetype"
  )
ELSE(STREAMRUNTIME_SDK_PROJECT)
  IF(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_FREETYPE}/include/freetype"
    )
  ELSE(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/freetype/include"
  )
  ENDIF(LIBS_BUILD_FREETYPE)
ENDIF(STREAMRUNTIME_SDK_PROJECT)

IF(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${CMAKE_BINARY_DIR}"
      PRIVATE "${PATH_LIBS}/FreeRTOS/rza"
      PRIVATE "${PATH_LIBS}/FreeRTOS/rza/${CMAKE_BUILD_TYPE}"
    )
ELSE(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/freetype/lib"
      PRIVATE "${CMAKE_BINARY_DIR}"
      PRIVATE "${CMAKE_BSP_SUBDIRECTORY}/${CMAKE_BUILD_TYPE}"
    )
ENDIF(STREAMRUNTIME_SDK_PROJECT)

# BSP-folder is not added since we use a prebuilt library
#ADD_SUBDIRECTORY(${CMAKE_BSP_SUBDIRECTORY} ./BSP)

SET(PLATFORM_LIBS
    ${PLATFORM_LIBS}
    "BSP"
)

SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${LINKER_SCRIPT}")

ADD_CUSTOM_TARGET(PostBuildTarget ALL
  COMMAND "${CMAKE_OBJCOPY}" --verbose -O binary $<TARGET_FILE:${PROJECT_NAME}> $<TARGET_FILE_DIR:${PROJECT_NAME}>/${PROJECT_NAME}.bin
  COMMAND "${TOOLCHAIN}/arm-none-eabi-size" $<TARGET_FILE:${PROJECT_NAME}>
  COMMENT "create binary file"
  DEPENDS ${PROJECT_NAME}
)
