#include "DemoProduct.h"

#include "GUI.h"

#include "GUITextField.h"
#include "GUIImageStack.h"
#include "GUISlider.h"
#include "GUIButton.h"
#include "GUIDataPool.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

void DemoProduct::Init()
{
}

DemoProduct::~DemoProduct()
{
    DeInit();
}

void DemoProduct::DeInit()
{
}

void DemoProduct::SetProductText(const ObjectHandle_t& eObjectID)
{
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(eObjectID));
    if (NULL != pkDialogCompObj)
    {
        CGUITextField* pkTextProduct = dynamic_cast<CGUITextField*>(pkDialogCompObj->GetObjectByID(TXT_PRODUCT_TEXT));
        if(pkTextProduct!=NULL)
        {
            pkTextProduct->SetValue(m_kProductText);
        }
    }
}

void DemoProduct::SetPictureToObjectID(const ObjectHandle_t& eObjectID, const ObjectHandle_t& eObjectIDSecond) 
{
    /* sets product picture to given picture object id */
    if (NO_HANDLE != eObjectID)
    {
        // Get the dialog of eObjectID, which is a composite object
        CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(eObjectID));
        if (NULL != pkDialogCompObj)
        {
            CGUIImage* pkImageProduct = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(eObjectIDSecond));
            if (NULL != pkImageProduct)
            {
                if (m_eImageMode == IM_BLACK_COFFEE_MODE)
                {
                    pkImageProduct->SetImage(IMG_KAFFEE_SCHWARZ, true);
                }
                else if (m_eImageMode == IM_WHITE_COFFEE_MODE)
                {
                    pkImageProduct->SetImage(IMG_KAFFE_WEISS, true);
                }
                else if (m_eImageMode == IM_ESPRESSO_MACH_MODE)
                {
                    pkImageProduct->SetImage(IMG_ESPRESSO_MACCHIATO, true);
                }
                else if (m_eImageMode == IM_ESPRESSO_MODE)
                {
                    pkImageProduct->SetImage(IMG_ESPRESSO, true);
                }
                else if (m_eImageMode == IM_CAPPUCINO_MODE)
                {
                    pkImageProduct->SetImage(IMG_CAPPUCCINO, true);
                }
                else if (m_eImageMode == IM_MOCHA_MODE)
                {
                    pkImageProduct->SetImage(IMG_MOCHA, true);
                }
                else if (m_eImageMode == IM_LATTE_MACH_MODE)
                {
                    pkImageProduct->SetImage(IMG_LATTE_MACCHIATO, true);
                }
                else if (m_eImageMode == IM_HOT_CHOCOLATE_MODE)
                {
                    pkImageProduct->SetImage(IMG_HEISSE_SCHOKOLADE, true);
                }
                else if (m_eImageMode == IM_HOT_WATER)
                {
                    pkImageProduct->SetImage(IMG_HEISSES_WASSER, true);
                }
                pkImageProduct->SetInvisible(false);
                pkImageProduct->InvalidateArea();
            }
        }
    }
}

void DemoProduct::SetPriceToObjectID(const ObjectHandle_t& eObjectID, const ObjectHandle_t& eObjectIDSecond) 
{
    /* sets price of the product to textfield */
    //break price in cents and euros
    eC_Int tmpCents = m_iPrice % 100;
    eC_Int tmpEur = (m_iPrice - tmpCents) / 100;

    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(eObjectID));
    if (pkDialogCompObj != NULL) {

        CGUITextField* pkTextField = static_cast<CGUITextField*>(pkDialogCompObj->GetObjectByID(eObjectIDSecond));
        if (pkTextField != NULL)
        {
            char text[8];
            sprintf(text, "%i,%02i", tmpEur, tmpCents);
            eC_String tmpStringDef(text);
            pkTextField->SetValue(tmpStringDef);
        }
    }
}

//setting objects gray in adjustments screen
void DemoProduct::GrayOutObjectAdjustmentsSugar()
{
    /* Adjusments dialogue screen - grays out everything related to sugar */
    m_iSugarBasePrice = 0;
    if (NO_HANDLE != AID_ADJUSTMENT_SCREEN)
    {
        // Get the dialog of eObjectID, which is a composite object
        // THE SLASH AND THE ICON
        CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
        if (NULL != pkDialogCompObj)
        {
            // THE SLASH
            CGUIImage* pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_2));
            if (NULL != pkGuiImgTmp)
            {
                pkGuiImgTmp->SetInvisible(true);
            }
            pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_2_GRAY));
            if (NULL != pkGuiImgTmp)
            {
                pkGuiImgTmp->SetInvisible(false);
            }
            // THE ICON
            pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SUGAR));
            if (NULL != pkGuiImgTmp)
            {
                pkGuiImgTmp->SetInvisible(true);
            }
            pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SUGAR_GRAY));
            if (NULL != pkGuiImgTmp)
            {
                pkGuiImgTmp->SetInvisible(false);
            }
            // THE NAME
            CGUITextField* guiTxtTmp = static_cast<CGUITextField*>(pkDialogCompObj->GetObjectByID(TXT_SUGAR));
            if (NULL != guiTxtTmp)
            {
                guiTxtTmp->SetGrayedOut(true);
            }
            // THE IMAGESTACK (METER)
            CGUIImageStack* guiImgstackMeterTmp = static_cast<CGUIImageStack*>(pkDialogCompObj->GetObjectByID(IMGSTACK_METER_2));
            if (NULL != guiImgstackMeterTmp)
            {
                guiImgstackMeterTmp->SetInvisible(true);
            }
            pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_METER_2_GRAY));
            if (NULL != pkGuiImgTmp)
            {
                pkGuiImgTmp->SetInvisible(false);
            }
            // THE SLIDER
            CGUISlider* pkGuiSliderTmp = static_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_2));
            if (NULL != pkGuiSliderTmp)
            {
                pkGuiSliderTmp->SetGrayedOut(true);
            }
        }
    }
}

void DemoProduct::GrayOutObjectAdjustmentsMilk() 
{
    /* Adjusments dialogue screen - grays out everything related to milk */
    m_iMilkBasePrice = 0;
    // Get the dialog of eObjectID, which is a composite object
    // THE SLASH AND THE ICON
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        // THE SLASH
        CGUIImage* pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_3));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(true);;
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_3_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE ICON
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_MILK));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(true);
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_MILK_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE NAME
        CGUITextField* guiTxtTmp = static_cast<CGUITextField*>(pkDialogCompObj->GetObjectByID(TXT_MILK));
        if (NULL != guiTxtTmp)
        {
            guiTxtTmp->SetGrayedOut(true);
        }
        // THE IMAGESTACK (METER)
        CGUIImageStack* guiImgstackMeterTmp = static_cast<CGUIImageStack*>(pkDialogCompObj->GetObjectByID(IMGSTACK_METER_3));
        if (NULL != guiImgstackMeterTmp)
        {
            guiImgstackMeterTmp->SetInvisible(true);
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_METER_3_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE SLIDER
        CGUISlider* pkGuiSliderTmp = static_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_3));
        if (NULL != pkGuiSliderTmp)
        {
            pkGuiSliderTmp->SetGrayedOut(true);
        }
    }
}

void DemoProduct::GrayOutObjectAdjustmentsFreness()
{
    /* Adjusments dialogue screen - grays out everything related to freness */
    // Get the dialog of eObjectID, which is a composite object
    // THE SLASH AND THE ICON
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        // THE SLASH
        CGUIImage* pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_4));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(true);
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_SLASH_4_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE ICON
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_FRENESS));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(true);
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_FRENESS_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE NAME
        CGUITextField* guiTxtTmp = static_cast<CGUITextField*>(pkDialogCompObj->GetObjectByID(TXT_FRENESS));
        if (NULL != guiTxtTmp)
        {
            guiTxtTmp->SetGrayedOut(true);
        }
        // THE IMAGESTACK (METER)
        CGUIImageStack* guiImgstackMeterTmp = static_cast<CGUIImageStack*>(pkDialogCompObj->GetObjectByID(IMGSTACK_METER_4));
        if (NULL != guiImgstackMeterTmp)
        {
            guiImgstackMeterTmp->SetInvisible(true);
        }
        pkGuiImgTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_METER_4_GRAY));
        if (NULL != pkGuiImgTmp)
        {
            pkGuiImgTmp->SetInvisible(false);
        }
        // THE SLIDER
        CGUISlider* pkGuiSliderTmp = static_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_4));
        if (NULL != pkGuiSliderTmp)
        {
            pkGuiSliderTmp->SetGrayedOut(true);
        }
    }
}

// Adjustments
void DemoProduct::SetSizeDialog() 
{
    /* Adjusments dialogue screen - size freness slider (depending on the product data) */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        // THE SLASH
        CGUISlider* pkGuiSliderTmp = dynamic_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_1));
        if (NULL != pkGuiSliderTmp)
        {
            pkGuiSliderTmp->SetValue(m_sizeLevel - 1);
        }
    }
}

void DemoProduct::SetSugarDialog() 
{
    /* Adjusments dialogue screen - sets sugar slider (depending on the product data) */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        // THE SLASH
        CGUISlider* pkGuiSliderTmp = dynamic_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_2));
        if (NULL != pkGuiSliderTmp)
        {
            pkGuiSliderTmp->SetValue(m_iSugarLevel);
        }
    }
}

void DemoProduct::SetMilkDialog() 
{
    /* Adjusments dialogue screen - sets milk slider (depending on the product data) */
    if (NO_HANDLE != AID_ADJUSTMENT_SCREEN)
    {
        // Get the dialog of eObjectID, which is a composite object
        CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
        if (NULL != pkDialogCompObj)
        {
            // THE SLASH
            CGUISlider* pkGuiSliderTmp = dynamic_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_3));
            CGUIImageStack* pkGuiImgStackTmp = dynamic_cast<CGUIImageStack*>(pkDialogCompObj->GetObjectByID(IMGSTACK_METER_3));
            if (NULL != pkGuiSliderTmp && NULL != pkGuiImgStackTmp)
            {
                pkGuiSliderTmp->SetValue(m_iMilkLevel);
                pkGuiImgStackTmp->SetAnimationIndex(m_iMilkLevel);
            }
        }
    }
}

void DemoProduct::SetFrenessDialog() 
{
    /* Adjusments dialogue screen - sets freness slider (depending on the product data) */

    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        // THE SLASH
        CGUISlider* pkGuiSliderTmp = dynamic_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_4));
        if (NULL != pkGuiSliderTmp)
        {
            pkGuiSliderTmp->SetValue(m_frenessLevel);
        }
    }
}

void DemoProduct::SaveAllAdjustmentsData() 
{
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIDataPool::Get(DATAPOOL_SLIDER1, m_vSliderValueFromDatapool);
        eC_Value vTmpSliderValue = m_vSliderValueFromDatapool.ToValue();

        m_sizeLevel = eC_Int(vTmpSliderValue) + 1;

        if ((m_eImageMode != IM_HOT_CHOCOLATE_MODE) && (m_eImageMode != IM_HOT_WATER)) 
        {
            m_iBeanLevel = m_sizeLevel;
        }

        CGUIDataPool::Get(DATAPOOL_SLIDER2, m_vSliderValueFromDatapool);
        vTmpSliderValue = m_vSliderValueFromDatapool.ToValue();

        m_iSugarLevel = eC_Int(vTmpSliderValue);

        CGUIDataPool::Get(DATAPOOL_SLIDER4, m_vSliderValueFromDatapool);
        vTmpSliderValue = m_vSliderValueFromDatapool.ToValue();

        m_frenessLevel = eC_Int(vTmpSliderValue);

        // slider 3 needs to be changed later
        CGUISlider* pkGuiSliderTmp = dynamic_cast<CGUISlider*>(pkDialogCompObj->GetObjectByID(SLIDER_3));
        if (NULL != pkGuiSliderTmp)
        {
            m_iMilkLevel = pkGuiSliderTmp->GetRange().GetValue();
        }
    }
}

void DemoProduct::SelectPaymentMethodMoney() 
{
    /* Payment dialogue screen - grays out Money and the rest is grayed in */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PAYMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_MONEY));
        if (NULL != pkGuiButtonTmp)
        {
            if (!(pkGuiButtonTmp->IsGrayedOut()))
            {
                pkGuiButtonTmp->SetGrayedOut(true);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CARD));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_SMART));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CODE));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
    }
}

void DemoProduct::SelectPaymentMethodCard() 
{
    /* Payment dialogue screen - grays out Card and the rest is grayed in */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PAYMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CARD));
        if (NULL != pkGuiButtonTmp)
        {
            if (!(pkGuiButtonTmp->IsGrayedOut()))
            {
                pkGuiButtonTmp->SetGrayedOut(true);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_MONEY));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_SMART));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CODE));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
    }
}

void DemoProduct::SelectPaymentMethodSmart() 
{
    /* Payment dialogue screen - grays out Smart and the rest is grayed in */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PAYMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_SMART));
        if (NULL != pkGuiButtonTmp)
        {
            if (!(pkGuiButtonTmp->IsGrayedOut()))
            {
                pkGuiButtonTmp->SetGrayedOut(true);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CARD));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_MONEY));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CODE));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
    }
}

void DemoProduct::SelectPaymentMethodCode() 
{
    /* Payment dialogue screen - grays out Code and the rest is grayed in */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PAYMENT_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CODE));
        if (NULL != pkGuiButtonTmp)
        {
            if (!(pkGuiButtonTmp->IsGrayedOut()))
            {
                pkGuiButtonTmp->SetGrayedOut(true);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_CARD));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_SMART));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
        pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_MONEY));
        if (NULL != pkGuiButtonTmp)
        {
            if (pkGuiButtonTmp->IsGrayedOut())
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
    }
}

void DemoProduct::UpdatePrice(ImageMode_t tmpMode) 
{
    /* calculates price of the product based on hte product mode and its parameters */
    if (tmpMode == IM_HOT_CHOCOLATE_MODE) 
    {
        m_iBeanBasePrice = 0;
    }
    else if (tmpMode == IM_HOT_WATER) 
    {
        m_iBeanBasePrice = 0;
    }
    else 
    {
        m_iBeanLevel = m_sizeLevel;
    }

    // calculate price
    m_iPrice = m_iBasePrice + (m_sizeLevel) * (m_iWaterBasePrice + m_iBeanBasePrice) + m_iSugarLevel * m_iSugarBasePrice + m_iMilkLevel * m_iMilkBasePrice;
}

void DemoProduct::SetAdjustmentValue() 
{
    /* sets values (sugar, size, milk, freness) of the product based of the selected product (product mode) */
    if (m_eImageMode == IM_BLACK_COFFEE_MODE) 
    {
        SetBaseLevels(2, 2, 0, 4);
    }
    else if (m_eImageMode == IM_WHITE_COFFEE_MODE) 
    {
        SetBaseLevels(2, 2, 2, 4);
    }
    else if (m_eImageMode == IM_ESPRESSO_MACH_MODE) 
    {
        SetBaseLevels(2, 2, 2, 8);
    }
    else if (m_eImageMode == IM_ESPRESSO_MODE) 
    {
        SetBaseLevels(2, 1, 0, 8);
    }
    else if (m_eImageMode == IM_CAPPUCINO_MODE) 
    {
        SetBaseLevels(2, 2, 2, 4);
    }
    else if (m_eImageMode == IM_MOCHA_MODE) 
    {
        SetBaseLevels(2, 1, 0, 8);
    }
    else if (m_eImageMode == IM_LATTE_MACH_MODE) 
    {
        SetBaseLevels(2, 3, 2, 4);
    }
    else if (m_eImageMode == IM_HOT_CHOCOLATE_MODE) 
    {
        SetBaseLevels(2, 3, 2, 0);
    }
    else if (m_eImageMode == IM_HOT_WATER) 
    {
        SetBaseLevels(0, 2, 0, 0);
    }
}

void DemoProduct::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY) 
{
    AdjustSliderMilk(kObservedValue, pkUpdatedObject);
    GrayOutBtnForwardAdj();
}

void DemoProduct::GrayOutBtnForwardAdj()
{
    /* grays out forward button in adjusments screen if there is not enaugh resources for product completion (milk, water, bean, suggar) */
    SaveAllAdjustmentsData();
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_ADJUSTMENT_SCREEN));

    if (NULL != pkDialogCompObj)
    {
        CGUIButton* pkButtonTmp = static_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_FORWARD));
        if (pkButtonTmp != NULL)
        {
            if ((m_iWater < m_sizeLevel) && (IsImgModeEqual(IM_HOT_CHOCOLATE_MODE)))
            {
                pkButtonTmp->SetGrayedOut(true);
            }
            else if (((m_iWater < m_sizeLevel) || (m_iSugar < m_iSugarLevel) || (m_iMilk < m_iMilkLevel)) && IsImgModeEqual(IM_HOT_CHOCOLATE_MODE)) 
            {
                pkButtonTmp->SetGrayedOut(true);

            }
            else if ((m_iWater < m_sizeLevel) || (m_iSugar < m_iSugarLevel) || (m_iMilk < m_iMilkLevel) || (m_iBean < m_iBeanLevel))
            {
                pkButtonTmp->SetGrayedOut(true);
            }
            else 
            {
                pkButtonTmp->SetGrayedOut(false);
            }
        }
    }
}

void DemoProduct::SetBaseLevels(eC_Int sugarTmp, eC_Int sizeTmp, eC_Int milkTmp, eC_Int frenessTmp) 
{
    /* sets product resource levels */
    m_iSugarLevel = sugarTmp;
    m_sizeLevel = sizeTmp;
    m_iMilkLevel = milkTmp;
    m_frenessLevel = frenessTmp;
}

void DemoProduct::AddObservers() 
{
    /* adds observers for the ajdustment screen */
    CGUIBaseSlider* pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_1));
    pkSliderTmp = NULL;
    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_1_1));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_2));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_2_1));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_3));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_3_1));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_4));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }

    pkSliderTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_4_1));
    if (NULL != pkSliderTmp)
    {
        pkSliderTmp->AddValueObserver(this);
    }
}

void DemoProduct::AdjustSliderMilk(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject) 
{
    /* reads and changes the values of milk slider and imagestack */
    CGUIBaseSlider* pkSliderFirstTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_3));
    CGUIBaseSlider* pkSliderSecondTmp = dynamic_cast<CGUIBaseSlider*>(GETGUI.GetObjectByID(SLIDER_3_1));

    if ((pkSliderFirstTmp != NULL) && (pkSliderSecondTmp != NULL)) 
    {
        // when changing the value of an observed slider, this leads to an additional OnNotification-call
        // thus only change, if values do not match
        if ((pkSliderFirstTmp->GetRange().GetValue()) != (pkSliderSecondTmp->GetRange().GetValue()))
        {
            if (pkUpdatedObject->GetID() == SLIDER_3) 
            {
                pkSliderSecondTmp->SetValue(kObservedValue);
                CGUIImageStack* pkGuiImgStackTmp = dynamic_cast<CGUIImageStack*>(GETGUI.GetObjectByID(IMGSTACK_METER_3));
                pkGuiImgStackTmp->SetValue(kObservedValue);
            }
            else if (pkUpdatedObject->GetID() == SLIDER_3_1) 
            {

                pkSliderFirstTmp->SetValue(kObservedValue);
                CGUIImageStack* pkGuiImgStackTmp = dynamic_cast<CGUIImageStack*>(GETGUI.GetObjectByID(IMGSTACK_METER_3));
                pkGuiImgStackTmp->SetValue(kObservedValue);
            }
        }
    }
}
