#include "DemoPassword.h"

#include "GUI.h"

#include "GUITextField.h"
#include "GUIImageStack.h"
#include "GUIButton.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

void DemoPassword::Init()
{
    m_iCurrentNumber = 0;
}

DemoPassword::~DemoPassword()
{
    DeInit();
}

void DemoPassword::DeInit()
{
}

void DemoPassword::ButtonPress(eC_Int button) 
{
    if ((button >= 0) && (button <= 9))
    {
        AddNumberToPassword(button);
        DrawStars();
        NextNumber();
    }
    else if (button == 10) 
    {
        UnDrawStars();
        PreviousNumber(); //replaces password number with 10's automatically
    }
    else if (button == 11) 
    {
        CleanPassword(); //deletas all
    }
    //cheks password
    LetItGo();
}

void DemoPassword::DrawStars() 
{
    /* function draws star (depending on the password input) in the password dialogue screen */
    // Get the dialog of eObjectID, which is a composite object
    // THE SLASH AND THE ICON
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PASSWORD_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        if (0 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_1));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(false);
            }
        }
        else if (1 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_2));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(false);
            }
        }
        else if (2 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_3));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(false);
            }
        }
        else if (3 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_4));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(false);
            }
        }
        else if (4 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_5));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(false);
            }
        }
    }
}

void DemoPassword::UnDrawStars()
{
    /* function makes stars invisible (depending on the current password) in the password dialogue screen */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PASSWORD_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        if (1 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_1));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(true);
            }
        }
        else if (2 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_2));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(true);
            }
        }
        else if (3 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_3));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(true);
            }
        }
        else if (4 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_4));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(true);
            }
        }
        else if (5 == m_iCurrentNumber) 
        {
            CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_5));
            if (NULL != pkGuiStarTmp)
            {
                pkGuiStarTmp->SetInvisible(true);
            }
        }
    }
}

void DemoPassword::LetItGo()
{
    /* function makes forward button grayedOut/grayedIn depending on the password input status in the password dialogue screen */
    if (m_iCurrentNumber == 5 && ComparePasswords()) 
    {
        CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PASSWORD_SCREEN));
        if (NULL != pkDialogCompObj)
        {
            CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_FORWARD));
            if (NULL != pkGuiButtonTmp)
            {
                pkGuiButtonTmp->SetGrayedOut(false);
            }
        }
    }
    else
    {
        CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PASSWORD_SCREEN));
        if (NULL != pkDialogCompObj)
        {
            CGUIButton* pkGuiButtonTmp = dynamic_cast<CGUIButton*>(pkDialogCompObj->GetObjectByID(BTN_FORWARD));
            if (NULL != pkGuiButtonTmp)
            {
                pkGuiButtonTmp->SetGrayedOut(true);
            }
        }
    }
}

void DemoPassword::CleanPassword() 
{
    /* undraws every star and resets passwords in the password dialogue screen */
    // Get the dialog of eObjectID, which is a composite object
    CGUICompositeObject *pkDialogCompObj = dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(AID_PASSWORD_SCREEN));
    if (NULL != pkDialogCompObj)
    {
        CGUIImage* pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_1));
        if (NULL != pkGuiStarTmp)
        {
            pkGuiStarTmp->SetInvisible(true);
        }
        pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_2));
        if (NULL != pkGuiStarTmp)
        {
            pkGuiStarTmp->SetInvisible(true);
        }
        pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_3));
        if (NULL != pkGuiStarTmp)
        {
            pkGuiStarTmp->SetInvisible(true);
        }
        pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_4));
        if (NULL != pkGuiStarTmp)
        {
            pkGuiStarTmp->SetInvisible(true);
        }

        pkGuiStarTmp = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(IMG_STAR_5));
        if (NULL != pkGuiStarTmp)
        {
            pkGuiStarTmp->SetInvisible(true);
        }
        m_iCurrentNumber = 0;
        ResetCurrentPassword();
    }
}
