#include "CustomExtensionFuncs.h"

// Include any headers for custom extensions here.
#include "CustomExtensionFactory.h"
#include "ExampleControl.h"
#include "ExampleBehaviour.h"
#include "ExampleLayouter.h"
#include "ExampleCommand.h"

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

void GetCustomEnumMappings(EnumMappingVector& rkEnumMappings)
{
    /* Add enum mappings for custom behaviours, controls, commands and layouters
       here. Example: your control 'MyControl' has an enum type 'MyEnum',
       values of which are written into streams with the XML tag 'MyEnumValue'.
       The enum values defined in the control are 'MY_VALUE_1' and 'MY_VALUE_2'.
       You would then add mappings as follows:
    rkEnumMappings.push_back(EnumMapping("MyEnumValue", MyControl::MY_VALUE_1, "MY_VALUE_1"));
    rkEnumMappings.push_back(EnumMapping("MyEnumValue", MyControl::MY_VALUE_2, "MY_VALUE_2"));
    */

    // Add the values for the DragAction enum in the ExampleBehaviour.
    rkEnumMappings.push_back(EnumMapping("DragAction", ExampleBehaviour::DA_MOVE, "DA_MOVE"));
    rkEnumMappings.push_back(EnumMapping("DragAction", ExampleBehaviour::DA_SIZE, "DA_SIZE"));
}

void GetCustomRepetitions(RepetitionVector& rkRepetitions)
{
    /* Add attribute repetition mappings for custom attribute repetitions here. 
       Example1: your repetition 'NumberOfImages' has one containing attribute value with XMLTag "ImageID"
       of attribute type AT_IMAGEID.

       rkRepetitions.push_back(AttributeRepetitionDescriptor("NumberOfImages", "ImageID", "DUMMY_IMAGE", CGUICommonEnums::AT_IMAGEID));

       Example2: you have a repetition named "SegmentColors" with two attributes
       name of the first is "Color" with type AT_COLOR and default value 0
       name of the second is "Value" with type AT_UINT and default value 0

       rkRepetitions.push_back(AttributeRepetitionDescriptor("SegmentColors", "Color", "0", CGUICommonEnums::AT_COLOR));
       rkRepetitions.push_back(AttributeRepetitionDescriptor("SegmentColors", "Value", "0", CGUICommonEnums::AT_UINT));

       Note:
       if a repetition with the given name already exists, the complete repetition will be ignored
       repetitions with an empty repetition title will also be ignored
    */
}
