/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef _MYGUI_SR_H_
#define _MYGUI_SR_H_

//Inludes
#include "GUIImage.h"

#include "DemoProduct.h"
#include "DemoPassword.h"

#include "StreamRuntimeGUI.h"

#define GETMYGUI    static_cast<CMyGUI&>(GETGUI)


struct ProductInfo_s
{
    ProductInfo_s() :
    eImageMode(DemoProduct::IM_NONE_MODE),
    eDisplayText(DUMMY_TEXT),
    kDisplayString(""),
    iPrice(0)
    {}

    DemoProduct::ImageMode_t eImageMode;
    TextResource_t eDisplayText;
    eC_String kDisplayString;
    eC_Int iPrice;
};



// Application specific CGUI instance. Implemented by customer.
class CMyGUI : public NStreamRuntime::CStreamRuntimeGUI
{
public:
    enum ScreenMode_enum
    {
        SCREEN_FIRST_MODE,
        SCREEN_MAIN_MODE,
        SCREEN_ADJUSTMENT_MODE,
        SCREEN_PAYMENT_MODE,
        SCREEN_PASSWORD_MODE,
        SCREEN_SETTINGS_MODE,
        SCREEN_PROCCESSING_MODE
    };

public:
    CMyGUI(eC_Value x, eC_Value y, eC_Value width, eC_Value height, ObjectHandle_t eID);
    virtual ~CMyGUI();

    /// Example implementation for simple Application <-> GUI communication
    void DoCallAPI(const eC_String& kAPI, const eC_String& kParam);

    virtual void DoAnimate(const eC_Value & vTimes = eC_FromInt(1));

    // set screen mode
    void SetScreenMode(ScreenMode_enum screenMode)
    {
        m_eScreenForIdle = screenMode;
    }

public:
    // top bar
    // variables need to be public in order to transfer them to DemoProduct class
    eC_Int m_iWater;
    eC_Int m_iMilk;
    eC_Int m_iBean;
    eC_Int m_iSugar;

private:

    void Cleanup();

    /* LAGNUGAGE */
    // change language 
    void ChangeLang(eC_Bool toggle);
    // back to main language flag
    void BackToMainLangFlag(eC_Bool toggle);

    /* PRODUCT RELATED */
    // Product price
    void UpdatePrice(const ObjectHandle_t& eObjectID);
    // Product gray out interface - adjustment screen
    void GrayOutAdjSugar();
    void GrayOutAdjMilk();
    void GrayOutAdjFreness();
    // adjustment screen sliders
    void SetAdjustmentsSliders();
    void SaveAdjustmentSliders();


    /* UPDATE PICTURE */
    void UpdatePicture(const ObjectHandle_t& eObjectID);

    /* PASSWORD */
    // Password screen
    void UpdatePassword(eC_Int tmpNumber);
    void CleanPassword();

    /* PAYMENT SCREEN*/
    // get back to previous screen
    void GetBackToAdjScreen();
    void GetBackToMainScreen();
    // Select payment method
    void SelectPaymentMethod(eC_String StringTmp);
    // Payment Complete
    void PaymentComplete();

    /* FIRST SCREEN LOGIC */
    void GetToMainScreen();
    void SleepFromScreen(const ObjectHandle_t& eObjectID);
    void WakeFromIdle();

    /* TIME */
    // set time
    void SetRightTime(const ObjectHandle_t& eObjectID);
    // clean time format
    eC_String CleanTimeFormat();

    /* TOP BAR */
    // top bar
    void SetTopBar(const ObjectHandle_t& eObjectID);


    // refill
    void Refill() 
    {
        m_iWater = 20;
        m_iMilk = 20;
        m_iBean = 20;
        m_iSugar = 20;
    }

    /* MAIN SCREEN */
    void GrayOutUnavailible();
    void GetToMainScreenWhenProcessed();

    //all screens

    void PrepareScreen(const ObjectHandle_t& eObjectID, ScreenMode_enum modeTmp);

private:
    ScreenMode_enum m_eScreenForIdle;
    eC_Bool m_bIdle;

    DemoProduct* m_pkProduct;
    DemoPassword* m_pkPassword;

    // time
    eC_Value m_vTime; // number of seconds till app start
    eC_Value m_vSeconds;
    eC_Value m_vSecondsForIdle;
    eC_Value m_vSecondsForProccessing;

    // product info struct
    ProductInfo_s m_kProductInfo[9];

    eC_Bool m_bEnglishActive;
    eC_UByte m_ubProfilingMode;
};

#endif //#ifndef _MYGUI_SR_H_
