#if !defined _DEMOPRODUCT_H_
#define _DEMOPRODUCT_H_

#include "DemoBase.h"
#include "GUIObserver.h"
#include "GUIImage.h"

#include "GUICompositeObject.h"

/*Class for the Product*/
class DemoProduct : public DemoBase, public CGUIObserver
{
public:
    enum ImageMode_t
    {
        IM_NONE_MODE,
        IM_BLACK_COFFEE_MODE,
        IM_WHITE_COFFEE_MODE,
        IM_ESPRESSO_MACH_MODE,
        IM_ESPRESSO_MODE,
        IM_CAPPUCINO_MODE,
        IM_MOCHA_MODE,
        IM_LATTE_MACH_MODE,
        IM_HOT_CHOCOLATE_MODE,
        IM_HOT_WATER
    };

    // adjustment screen check
    eC_Bool m_bWereInAdjScreen;

public:
    /* This class handles product information and everything that relates to the product
    (such ass graying out adjustment sliders, calculating price...) */

    // Only use second constructor
    DemoProduct()
    {}

    // This constructor takes information from the MyGUI_SR class
    DemoProduct(eC_Int waterTmp, eC_Int milkTmp, eC_Int beanTmp, eC_Int sugarTmp) :
        m_iSugarLevel(2),
        m_sizeLevel(2),
        m_iMilkLevel(2),
        m_frenessLevel(8),
        m_iBeanLevel(0),
        m_iSugarBasePrice(10),
        m_iMilkBasePrice(25),
        m_iWaterBasePrice(50),
        m_iBeanBasePrice(50),
        m_bWereInAdjScreen(false)
    {
        m_iWater = waterTmp;
        m_iMilk = milkTmp;
        m_iBean = beanTmp;
        m_iSugar = sugarTmp;
    }

    virtual ~DemoProduct();

    virtual void Init();

    virtual void DeInit();

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);



    /* Set and get functions */

    // image mode
    void SetImageModeDefault() 
    {
        m_eImageMode = IM_NONE_MODE;
    }
    void SetImageMode(ImageMode_t modeTmp) 
    {
        m_eImageMode = modeTmp;
        SetAdjustmentValue();
    }
    ImageMode_t GetImageMode() 
    {
        return m_eImageMode;
    }
    // price
    void SetBasePrice(eC_Int tmpPrice) 
    {
        m_iBasePrice = tmpPrice;
    }
    eC_Int GetPrice() 
    {
        return m_iPrice;
    }


    // Adjustments
    // size
    eC_Int GetSize() 
    {
        return m_sizeLevel;
    }
    // sugar
    eC_Int GetSugar() 
    {
        return m_iSugarLevel;
    }
    // milk
    eC_Int GetMilk() 
    {
        return m_iMilkLevel;
    }
    eC_Int GetFreness() 
    {
        return m_frenessLevel;
    }
    eC_Int GetBean() 
    {
        return m_iBeanLevel;
    }

    // are image modes equal
    eC_Bool IsImgModeEqual(ImageMode_t imgModeTmp) 
    {
        if (m_eImageMode == imgModeTmp) 
        {
            return true;
        }
        else 
        {
            return false;
        }
    }
    // set product text
    void SetProductText(eC_String textTmp) 
    {
        m_kProductText = textTmp;
    }

    // product information
    void SetPictureToObjectID(const ObjectHandle_t& eObjectID, const ObjectHandle_t& eObjectIDSecond);
    void SetPriceToObjectID(const ObjectHandle_t& eObjectID, const ObjectHandle_t& eObjectIDSecond);
    void UpdatePrice(ImageMode_t tmpMode);

    // graying out adjustments
    void GrayOutObjectAdjustmentsSugar();
    void GrayOutObjectAdjustmentsMilk();
    void GrayOutObjectAdjustmentsFreness();

    // adjustments
    void SetSizeDialog();
    void SetSugarDialog();
    void SetMilkDialog();
    void SetFrenessDialog();
    // set adjustment value depending on the product
    void SetAdjustmentValue();

    void SaveAllAdjustmentsData();


    // select payment method
    void SelectPaymentMethodMoney();
    void SelectPaymentMethodCard();
    void SelectPaymentMethodSmart();
    void SelectPaymentMethodCode();

    void SetProductText(const ObjectHandle_t& eObjectID);

    //adjustment screen controllers

    void GrayOutBtnForwardAdj();

    void AddObservers();

    void AdjustSliderMilk(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject);

private:
    //function for the values
    void SetBaseLevels(eC_Int sugarTmp, eC_Int sizeTmp, eC_Int milkTmp, eC_Int frenessTmp);

private:

    ImageMode_t m_eImageMode;
    eC_String m_kProductText;

    // bace price
    eC_Int m_iBasePrice;
    eC_Int m_iPrice;

    // adjustments levels
    eC_Int m_iSugarLevel;

    eC_Int m_sizeLevel;
    eC_Int m_iMilkLevel;
    eC_Int m_frenessLevel;
    eC_Int m_iBeanLevel;

    // base prices
    eC_Int m_iSugarBasePrice;
    eC_Int m_iMilkBasePrice;
    eC_Int m_iWaterBasePrice;
    eC_Int m_iBeanBasePrice;


    //test
    CGUIValue m_vSliderValueFromDatapool;

    //resource info from main gui
    eC_Int m_iWater;
    eC_Int m_iBean;
    eC_Int m_iSugar;
    eC_Int m_iMilk;
};
#endif

