#if !defined _DEMOPASSWORD_H_
#define _DEMOPASSWORD_H_

#include "DemoBase.h"
#include "GUIObserver.h"
#include "GUIImage.h"

#include "GUICompositeObject.h"



/*Class for the Password*/
class DemoPassword : public DemoBase
{
public:


    DemoPassword() :
        m_iCurrentNumber(0)
    {
        m_iRealPassword[0] = 1;
        m_iRealPassword[1] = 2;
        m_iRealPassword[2] = 3;
        m_iRealPassword[3] = 4;
        m_iRealPassword[4] = 5;

        m_iCurrentPassword[0] = 10;
        m_iCurrentPassword[1] = 10;
        m_iCurrentPassword[2] = 10;
        m_iCurrentPassword[3] = 10;
        m_iCurrentPassword[4] = 10;

    }

    virtual ~DemoPassword();

    virtual void Init();

    virtual void DeInit();


    // Sequence count
    void NextNumber() {
        if (m_iCurrentNumber < 5)
            m_iCurrentNumber = m_iCurrentNumber + 1;
    }
    void PreviousNumber() {
        if (m_iCurrentNumber > 0) {
            m_iCurrentPassword[--m_iCurrentNumber] = 0;
        }
    }

    // Passwords
    void AddNumberToPassword(eC_Int intTmp) {
        if (m_iCurrentNumber < 5)
            m_iCurrentPassword[m_iCurrentNumber] = intTmp;
    }
    eC_Bool ComparePasswords() {
        eC_Int trueCounter = 0;
        for (eC_Int i = 0; i < 5; i++) {
            if (m_iRealPassword[i] == m_iCurrentPassword[i])
                trueCounter++;
        }
        if (trueCounter == 5)
            return true;
        else
            return false;
    }
    void ResetCurrentPassword() {
        for (eC_Int i = 0; i < 5; i++) {
            m_iCurrentPassword[i] = 0;
        }
    }

    // Interface functions
    void ButtonPress(eC_Int button);
    void DrawStars();
    void UnDrawStars();

    void LetItGo();
    void CleanPassword();

private:
    eC_Int m_iRealPassword[5];
    eC_Int m_iCurrentPassword[5];
    eC_Int m_iCurrentNumber;
};


#endif