/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

extern "C"
{
#include "r_typedefs.h"
#include "iodefine.h"
#include "r_cpg_drv_api.h"
#include "r_ostm_drv_api.h"
#include "r_scifa_drv_api.h"
#include "r_gpio_drv_api.h"
#include "r_startup_config.h"
#include "compiler_settings.h"
#include "r_os_abstraction_api.h"
#include "r_task_priority.h"

#include "iodefine.h"
}

// Standard Headers
#include <new>
#include <string.h>

// Guiliani Headers
#include "GUIConfigDebug.h"

#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "StreamRuntimeConfig.h"
#include "StreamRuntimeStartup.h"

#include "GUIInputMedia.h"
#include "GUIEvent.h"

// Mem leak watcher need to be last
#include "GUIMemLeakWatcher.h"

// Resources FLASH section, size can be adapted here if needed
extern const uint8_t __attribute__ ((section (".RES_FLASH"))) __guilianiResources[0x3000000];

#ifdef   __cplusplus
extern "C"
{
#endif
void GuilianiStart()
{
    GUI_REG_STDOUT_TRACE();

    GUILOG(GUI_TRACE_DEBUG, "CMyGUI::Init: RESOURCE FILE ACTIVE!\n");

    // use a resource file containing all required images, fonts, texts etc.
    GETRESHANDLER.SetResourceData(__guilianiResources);

    // Use CGUI::SetGuilianiLicenseKey("<ENTER YOUR CODE HERE>")) to set your Guiliani license key via code.
    // Alternatively use CGUI::LoadGuilianiLicenseKey("GuilianiLicense.key") to read your Guiliani license key from a file.

    NStreamRuntime::CStreamRuntimeStartup kStreamRuntime;

    try
    {
        // Load configuration (e.g. ScreenSize, initial Dialog etc.) from file
        if (kStreamRuntime.LoadConfiguration() == false)
        {
            return;
        }

        kStreamRuntime.ConstructWrapperClasses();

		kStreamRuntime.CreateGUI();
    }
    catch (...)
    {
        GUILOG( GUI_TRACE_ERROR, "An unrecoverable error occurred. Executing clean shutdown. \n");
    }

    kStreamRuntime.DestructWrapperClasses();

    GUILOG(GUI_TRACE_DEBUG, "Guiliani shutdown complete.\n");
}

#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    extern volatile uint8_t ucHeap[ configTOTAL_HEAP_SIZE ];
#endif

void* GetHeapStart()
{
#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    return (void*)&ucHeap[0];
#else
    #error "no heap allocated"
    return NULL;
#endif
}

void* GetHeapEnd()
{
#if( configAPPLICATION_ALLOCATED_HEAP == 1 )
    return (void*)((uint8_t*)&ucHeap[0] + configTOTAL_HEAP_SIZE);
#else
    #error "no heap allocated"
    return NULL;
#endif
}

#ifdef   __cplusplus
}
#endif
