/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

#include "StreamRuntimeStartup.h"

#include "GUIConfigDebug.h"

#include "MyGUI_SR.h"
#include "GUITrace.h"
#include "GUIResourceFileHandler.h"
#include "GUIImageCache.h"
#include "StreamRuntimeConfig.h"

// Graphic and Font Wrapper
#if defined PLATFORM_RENESAS_RZA2M
    #include "GfxEnvRVAPI.h"
#elif defined PLATFORM_RENESAS_GRMANGO
extern "C"
{
        #include "r_rvapi_vdc.h"
}
    #include "GfxEnvRVAPI.h"
#elif defined PLATFORM_RENESAS_RZA3UL
    #include "GfxEnvRZA3.h"
#elif defined PLATFORM_RENESAS_RZA2M_M13
    #include "GfxEnvRZA2M.h"
#else
    #include "GfxEnvVDC0.h"
#endif

#if defined GFX_USE_RGA
    #include "GfxWrapRGA.h"
    #include "FntWrapFreeTypeRGA.h"
#elif defined GFX_USE_EGML
    #include "GfxWrapeGML.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeType.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLib.h"
    #endif
#elif defined GFX_USE_DAVE
    #if defined PLATFORM_RENESAS_RZA2M
        #include "GfxWrapDave.h"
    #endif

    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeType.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibDAVECached.h"
    #endif
#elif defined GFX_USE_BLU
    #include "GfxWrapBLU.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeType.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLib.h"
    #endif
#else
    #include "GfxWrapNull.h"
#endif

#include "FntWrapNull.h"

// Sound Wrapper
#include "SndWrapNull.h"

// Input Wrapper
#ifdef PLATFORM_RENESAS_DISPLAYIT_V1      
    #include "GUIInputDisplayIt.h"
#elif defined PLATFORM_RENESAS_DISPLAYIT_V2
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_STREAMIT_V2
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_GRPEACH
    #include "GUIInputStreamIt.h"
#elif defined PLATFORM_RENESAS_RZA2M
    #include "GUIInputRZA2M.h"
#elif defined PLATFORM_RENESAS_GRMANGO
    #include "GUIInputRZA2M.h"
#elif defined PLATFORM_RENESAS_RZA3UL
    #include "GUIInputRZA3.h"
#elif defined PLATFORM_RENESAS_RZA2M_M13
    #include "GUIInputRZA2M_M13.h"
#else
    #include "GUIInputExample.h"
#endif

#include "GUIConfigDebug.h"
#include "GUIException.h"
#include "GUIThread.h"
#include "GUIPlaybackInput.h"

// Memory Leak Detection
#include "GUIMemLeakWatcher.h"

extern volatile uint8_t* RZAFrameBuffers[];

#if defined PLATFORM_RENESAS_RZA2M || defined PLATFORM_RENESAS_GRMANGO
#define LAYER2_WIDTH 160
#define LAYER2_HEIGHT 120
#define LAYER2_PADDED_WIDTH 160
#define LAYER2_BUFFER_NUM 2

uint8_t Layer2[LAYER2_BUFFER_NUM][LAYER2_PADDED_WIDTH * LAYER2_HEIGHT * 2] __attribute__ ((section(".VRAM_SECTION0")));

volatile uint8_t* Layer2Buffers[2] =
{
	Layer2[1],
	Layer2[0]
};
#endif

namespace NStreamRuntime
{
  void CStreamRuntimeStartup::ConstructWrapperClasses()
  {
    /* Sets the graphics and font wrapper */
    try
    {
        CGUICommonEnums::ImageType_t eFormat = CGUICommonEnums::RGB_565;
#if defined GFX_USE_ARGB32
        eFormat = CGUICommonEnums::ARGB_8888;
#endif

#if defined PLATFORM_RENESAS_RZA2M || defined PLATFORM_RENESAS_GRMANGO
        CGfxEnvRVAPI::CreateInstance(CGfxEnv::SM_FRAMEBUFFER, eFormat, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, (void**)RZAFrameBuffers);

        LayerConfiguration_t kLayer2;
        kLayer2.m_uiLayerID = VDC_LAYER_ID_2_RD;
        kLayer2.m_uiWidth = LAYER2_WIDTH;
        kLayer2.m_uiHeight = LAYER2_HEIGHT;
        kLayer2.m_uiPaddedWidth = LAYER2_PADDED_WIDTH;
        kLayer2.m_ePixFormat = CGUICommonEnums::RGB_565;
        kLayer2.m_uiNumBuffers = LAYER2_BUFFER_NUM;
        kLayer2.m_pkBuffers[0] = Layer2Buffers[0];
        kLayer2.m_pkBuffers[1] = Layer2Buffers[1];
        kLayer2.m_bCached = true;
        kLayer2.m_bChromaKeyActive = true;
        kLayer2.m_uiChromaKey = 0xFFFF;

        GETGFXENV.SetMainLayerProperties(VDC_LAYER_ID_0_RD, true);
        GETGFXENV.AddLayer(kLayer2);
        
#elif defined PLATFORM_RENESAS_RZA3UL
        CGfxEnvRZA3::CreateInstance(CGfxEnv::SM_FRAMEBUFFER, eFormat, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, (void**)RZAFrameBuffers);
#elif defined PLATFORM_RENESAS_RZA2M_M13
        CGfxEnvRZA2M::CreateInstance(CGfxEnv::SM_FRAMEBUFFER, eFormat, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, (void**)RZAFrameBuffers);
#else
        CGfxEnvVDC0::CreateInstance(CGfxEnv::SM_FRAMEBUFFER, eFormat, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, (void**)RZAFrameBuffers);
#endif
        GETGFXENV.InitLayers();

#if defined GFX_USE_RGA
        CGfxWrapRGA::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT);
        CFntWrapFreeTypeRGA::CreateInstance(512*512, (static_cast<CGfxWrapRGA&> (CGfxWrapRGA::GetInstance())).GetContext(),
                                                     (static_cast<CGfxWrapRGA&> (CGfxWrapRGA::GetInstance())).GetFrameBuffer());
#elif defined GFX_USE_EGML

        CGfxWrapeGML::CreateInstance(&GETGFXENV);

#if defined FNT_USE_FREETYPE
        CFntWrapFreeType::CreateInstance(128 * 128);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLib::CreateInstance();
#endif

#elif defined GFX_USE_BLU
        CGfxWrapBLU::CreateInstance(&GETGFXENV);

#if defined FNT_USE_FREETYPE
        CFntWrapFreeType::CreateInstance(512 * 512);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLib::CreateInstance();
#endif

#elif defined GFX_USE_DAVE
        CGfxWrapDAVE::CreateInstance(&GETGFXENV);
#if defined PLATFORM_RENESAS_RA6M3
        CGfxWrapDAVERA6M3::CreateInstance(FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, RZAFrameBuffers);
#endif

#if defined FNT_USE_FREETYPE
        CFntWrapFreeType::CreateInstance(1024 * 1024);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLib::CreateInstance();
#endif
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate graphics wrapper.\n");
    }

    // Sets the sound wrapper
    try
    {
      CSndWrapNull::CreateInstance();
    }
    catch (...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not allocate sound wrapper.\n");
    }

    // Set pointer to resource file handler instance
    try
    {
#ifdef PLATFORM_RENESAS_DISPLAYIT_V1      
      CGUIInputDisplayIt::CreateInstance();
#elif defined PLATFORM_RENESAS_DISPLAYIT_V2
      CGUIInputStreamIt::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2);
#elif defined PLATFORM_RENESAS_STREAMIT_V2
      CGUIInputStreamIt::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2);
#elif defined PLATFORM_RENESAS_GRPEACH
      CGUIInputStreamIt::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2);
#elif defined PLATFORM_RENESAS_RZA2M
      CGUIInputRZA2M::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, 30, 10);
#elif defined PLATFORM_RENESAS_GRMANGO
      CGUIInputRZA2M::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, 30, 10);
#elif defined PLATFORM_RENESAS_RZA3UL
      CGUIInputRZA3::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 4);
#elif defined PLATFORM_RENESAS_RZA2M_M13
      CGUIInputRZA2M::CreateInstance(0, 0, FRAME_BUFFER_WIDTH, FRAME_BUFFER_HEIGHT, 2, 30, 10);
#else
      CGUIInputExample::CreateInstance();
#endif
    }
    catch(...)
    {
      GUILOG_THROW_EXCEPTION(CGUIException(), "NStartup::ConstructResourceClasses: Could not create input media.\n");
    }
    GETRESHANDLER.SetResourcePathPrefix("./");
  }
}
