/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __STREAMRUNTIME_STARTUP_H__
#define __STREAMRUNTIME_STARTUP_H__

#include "StreamRuntimeBase.h"

#include <Windows.h>

/** The NStreamRuntime Namespace contains generic helper classes for initializing a default StreamRuntime application.
    The code herein typically remains widely unchanged across most StreamRuntimes.
    Feel free to remove these classes from your own application and replace them with custom code, if you wish.*/
namespace NStreamRuntime
{
    class CStreamRuntimeStartup : public CStreamRuntimeBase
    {
    public:
        CStreamRuntimeStartup() :
            m_hWnd(NULL),
            m_hInstance(NULL)
        {}

        // Windows specific methods for creating the application window
        void Init(HINSTANCE hInstance, int nCmdShow);

        // Methods for Initialization/Shutdown of Guiliani 
        virtual void ConstructWrapperClasses();

        HWND GetWindow() { return m_hWnd; }

    private:
        BOOL OpenWindow(int nCmdShow);
        ATOM MyRegisterClass();
        static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

        HWND m_hWnd;
        HINSTANCE m_hInstance;
    };
}
#endif
