#ifndef __GUIINPUT_RZA2M_H__
#define __GUIINPUTR_ZA2M_H__

#include "eC_Semaphore.h"
#include "eC_Types.h"
#include "eC_TList_doubleLinked.h"
#include "GUIInputMedia.h"
#include "GUIEvent.h"

//----------------------------------
#define TP_TOUCHNUM_MAX 5

typedef enum {
    TPEVT_ENTRY_NONE    = 0x0000,      /*!< None */
    TPEVT_ENTRY_UP      = 0x0001,      /*!< Up */
    TPEVT_ENTRY_DOWN    = 0x0002,      /*!< Down */
    TPEVT_ENTRY_MOVE    = 0x0004,      /*!< Move */

    TPEVT_ENTRY_ALL     = 0x0007,      /*!< All */

    TPEVT_ENTRY_UNKNOWN = 0x8000       /*!< internal event state */
} TpEvt_EntryType ;

typedef struct {
    TpEvt_EntryType     eState;
    uint16_t            unPosX;
    uint16_t            unPosY;
} TP_TouchFinger_st;

typedef struct {
    TP_TouchFinger_st   sFinger[TP_TOUCHNUM_MAX];
} TP_TouchEvent_st;

typedef struct {
    int32_t x ;        /*!< x-coordinate [pixel] */
    int32_t y ;        /*!< y-coordinate [pixel] */
} TPEVT_COORDINATES ;
//----------------------------------

/** this class is used as the input-device for RZ/A2M
*/
class CGUIInputRZA2M : public CGUIInputMedia
{
public:
    /** Create instance
    @param iTouchScreenX offset
    @param iTouchScreenY offset
    @param iTouchScreenWidth width
    @param iTouchScreenHeight height
    @param iTouchFilterDelta filter-delta
    @param uiIntPriority interrupt-priority
    @param iTaskPriority task-priority
    */
    static void CreateInstance(
        const eC_Int& iTouchScreenX,
        const eC_Int& iTouchScreenY,
        const eC_Int& iTouchScreenWidth,
        const eC_Int& iTouchScreenHeight,
        const eC_Int& iTouchFilterDelta,
        const eC_UInt& uiIntPriority = 30,
        const eC_Int& iTaskPriority = R_OS_TASK_MAIN_TASK_PRI+1);

    virtual CGUIEvent* GetEvent(eC_UInt uiIdleTime);
    
    /** add a new event
    @param kTouchEvent event
    */
    void AddEvent(TP_TouchFinger_st kTouchEvent);

protected:
    /** constructor
    @param iTouchScreenX offset
    @param iTouchScreenY offset
    @param iTouchScreenWidth width
    @param iTouchScreenHeight height
    @param iTouchFilterDelta filter-delta
    @param uiIntPriority interrupt-priority
    @param iTaskPriority task-priority
    */
    CGUIInputRZA2M(
        const eC_Int& iTouchScreenX,
        const eC_Int& iTouchScreenY,
        const eC_Int& iTouchScreenWidth,
        const eC_Int& iTouchScreenHeight,
        const eC_Int& iTouchFilterDelta,
        const eC_UInt& uiIntPriority,
        const eC_Int& iTaskPriority);

    ~CGUIInputRZA2M();
    
private:
    /**
        Copy-constructor.
        @param kSource Source object to be copied.
     */
    CGUIInputRZA2M(const CGUIInputRZA2M& kSource) {}

    /**
        Operator= method.
        @param kSource Source object to be copied.
        @return This instance.
     */
    CGUIInputRZA2M& operator=(const CGUIInputRZA2M& kSource) {return *this;}
    
private:
    eC_Semaphore m_kSemaphore;
    eC_TListDoubleLinked<TP_TouchFinger_st> m_kEventQueue;
    
    TP_TouchFinger_st m_kLastEvent;  
    eC_Bool m_bEventReady;

    eC_Int m_iTouchScreenX;
    eC_Int m_iTouchScreenY;
    eC_Int m_iTouchScreenWidth;
    eC_Int m_iTouchScreenHeight;
    eC_Int m_iTouchFilterDelta;
    
    TpEvt_EntryType m_eLastTouchEvent;
    
    eC_Int m_iLastPositionX;
    eC_Int m_iLastPositionY;

    eC_Int m_iLastDraggedX;
    eC_Int m_iLastDraggedY;
    eC_UInt m_uiIntPriority;
    eC_Int m_iTaskPriority;
};
#endif
