/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(EXAMPLE_TEXTTYPE_H)
#define EXAMPLE_TEXTTYPE_H

#include "GUICompositeObject.h"
#include "GUIText.h"

/** An example texttype
*/
class ExampleTextType : public CGUIText
{
public:
    /** Constructs an ExampleLayouter.
    @param bHorizontal Whether the object is centered horizontally in its parent.
    @param bVertical Whether the object is centered vertically in its parent.
    @param pkObject Pointer to object to be associated with this layouter.
    */
    ExampleTextType(
        CGUICompositeObject* const pkParent,
        const eC_Value& vX, const eC_Value& vY,
        const eC_String& kText);

    // method used by the factory to create new instance
    static CGUIText* Create()
    {
        return new ExampleTextType(NULL, eC_FromInt(0), eC_FromInt(0), "sample text");
    }

#if defined(GUILIANI_STREAM_GUI)
    /** Reads all attributes from streaming file.
    This method is called by CGUIFactoryManager after one of the registered
    factories has created an instance of this class.
    */
    virtual void ReadFromStream();
#endif

#if defined(GUILIANI_WRITE_GUI)
    /** Writes all attributes to the streaming file. A CGUIStreamWriter
    has to be initialized first.
    @param bWriteClassID This flag is used to select whether writing of layouter ID,
    leading and trailing tags is performed.
    */
    virtual void WriteToStream(const eC_Bool bWriteClassID = false);
#endif

private:


    static bool ms_bInitialized;
};

#endif // EXAMPLE_LAYOUTER_H
