
#
# FreeRTOS-GNU-arm-rza2m specific settings
#

# set outputs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES RUNTIME_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Binary/${CMAKE_SYSTEM_NAME}/${CMAKE_PLATFORM_NAME}/${CMAKE_CXX_COMPILER_ID}/${CMAKE_BUILD_TYPE}")

FILE(GLOB PLATFORM_COMMON_RZA_CPP "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntimeStartup.cpp")

IF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_RZA2M")
FILE(GLOB PLATFORM_RZA_CPP
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/new_delete.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_RZA2M_FreeRTOS10.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_RZA2M_FreeRTOS10_main.c"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/rza2m/GfxEnvRVAPI.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/rza2m/GUIInputRZA2M.cpp"
    )
ENDIF()

IF(${PLATFORM_NAME} STREQUAL "PLATFORM_RENESAS_RZA2M_M13")
FILE(GLOB PLATFORM_RZA_CPP
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/new_delete.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_RZA2M_M13_FreeRTOS10.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_RZA2M_M13_FreeRTOS10_main.c"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/FreeRTOS/StreamRuntime_RZA2M_M13_Graphic.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/rza2m/GfxEnvRZA2M.cpp"
    "${PROJECT_SOURCE_DIR}/Common/Source/Platform/rza2m/GUIInputRZA2M_M13.cpp"
    )
ENDIF()

SET(PLATFORM_FILES 
    ${PLATFORM_RZA_CPP}
    ${PLATFORM_COMMON_RZA_CPP}
    ${SYSCALLS_C}
)

TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
  PRIVATE "${PROJECT_SOURCE_DIR}/Common/Include/Platform/FreeRTOS"
  PRIVATE "${PROJECT_SOURCE_DIR}/Common/Include/Platform/rza2m"
)

#BLU
IF(GUILIANI_ADD_BLU_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_BLU}/Include"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/BLU"
  )
ENDIF(GUILIANI_ADD_BLU_PLATFORM)

#eGML
IF(GUILIANI_ADD_EGML_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GUILIANI}/Include/Platform/eGML"
  )
ENDIF(GUILIANI_ADD_EGML_PLATFORM)

#DAVE
IF(GUILIANI_ADD_DAVE_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_DAVE}/Include"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/DAVE"
    )
ENDIF(GUILIANI_ADD_DAVE_PLATFORM)

#GlyphLib
IF(GUILIANI_ADD_GLYPHLIB_PLATFORM)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_GLYPHLIB}/Include"
    PRIVATE "${PATH_GUILIANI}/Include/Platform/GlyphLib"
  )
ENDIF(GUILIANI_ADD_GLYPHLIB_PLATFORM)

IF(STREAMRUNTIME_SDK_PROJECT)
  # Some platform depenant include directories.
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/Include/eGML"
    PRIVATE "${PATH_EGAC}/Include/eDBG"
    PRIVATE "${PATH_EGAC}/Include/eC/FreeRTOS"
    PRIVATE "${PATH_LIBS}/freetype/include"
    PRIVATE "${PATH_LIBS}/freetype/include/freetype"
  )
ELSE(STREAMRUNTIME_SDK_PROJECT)
  IF(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_FREETYPE}/include/freetype"
    )
  ELSE(LIBS_BUILD_FREETYPE)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/freetype/include"
    )
  ENDIF(LIBS_BUILD_FREETYPE)
ENDIF(STREAMRUNTIME_SDK_PROJECT)

IF(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${CMAKE_BINARY_DIR}"
      PRIVATE "${PATH_LIBS}/FreeRTOS/rza"
      PRIVATE "${PATH_LIBS}/FreeRTOS/rza/${CMAKE_BUILD_TYPE}"
    )
ELSE(STREAMRUNTIME_SDK_PROJECT)
    TARGET_LINK_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/freetype/lib"
      PRIVATE "${CMAKE_BINARY_DIR}"
    )
ENDIF(STREAMRUNTIME_SDK_PROJECT)

ADD_SUBDIRECTORY(${CMAKE_BSP_SUBDIRECTORY} ./BSP)

SET(PLATFORM_LIBS
    ${PLATFORM_LIBS}
    "BSP"
)

SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${LINKER_SCRIPT}")

ADD_CUSTOM_TARGET(PostBuildTarget ALL
  COMMAND "${CMAKE_OBJCOPY}" --verbose -O binary $<TARGET_FILE:${PROJECT_NAME}> $<TARGET_FILE_DIR:${PROJECT_NAME}>/${PROJECT_NAME}.bin
  COMMAND "${TOOLCHAIN}/arm-none-eabi-size" $<TARGET_FILE:${PROJECT_NAME}>
  COMMENT "create binary file"
  DEPENDS ${PROJECT_NAME}
)
