/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef __GUI_CUSTOM_MEMORY_MAPPING_FUNCTIONS_H__
#define __GUI_CUSTOM_MEMORY_MAPPING_FUNCTIONS_H__

#ifdef eC_CUSTOM_MEMORY_MAPPING

#include "eC_Memory.h"

void CustomMemoryMapping_delete(int dummy)
{
}

void* CustomMemoryMapping_malloc(size_t uiSize, int dummy)
{
    return eC_Malloc(uiSize);
}

void CustomMemoryMapping_free(void* pMemory, int dummy)
{
    eC_Free(pMemory);
}

void* CustomMemoryMapping_realloc(void* pMemory, size_t uiSize, int dummy)
{
    eC_Free(pMemory);
    return eC_Malloc(uiSize);
}

void* operator new(size_t uiSize, int dummy)
{
    return eC_Malloc(uiSize);
}

// Vector new routine
void* operator new[](size_t uiSize, int dummy)
{
    return eC_Malloc(uiSize);
}

void operator delete(void* pMemory) throw()
{
    eC_Free(pMemory);
}

// Vector delete routine
void operator delete[](void* pMemory) throw()
{
    eC_Free(pMemory);
}

#endif //#ifdef eC_CUSTOM_MEMORY_MAPPING

#endif
