/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

/**
@warning Always include this file as the LAST included header in your .cpp files!
*/

#ifdef eC_CUSTOM_MEMORY_MAPPING

#include <stddef.h>

// this removes function-definitions to change overload
#include "eC_CustomMemoryMappingUndef.h"

/** memory-mapping function used with delete()
*/
void CustomMemoryMapping_delete(int dummy);

/** memory-mapping function used with malloc()
@param uiSize Size
*/
void* CustomMemoryMapping_malloc(size_t uiSize, int dummy);

/** memory-mapping function used with free()
@param pMemory Pointer to allocated memory
*/
void CustomMemoryMapping_free(void* pMemory, int dummy);

/** memory-mapping function used with realloc()
@param pMemory Pointer to allocated memory
@param uiSize Size
*/
void* CustomMemoryMapping_realloc(void* pMemory, size_t uiSize, int dummy);

/** memory-mapping function used with new() operator
@param uiSize Size
*/
void* operator new(size_t uiSize, int dummy);

/** memory-mapping function used with new[] operator
@param uiSize Size
*/
void* operator new[](size_t uiSize, int dummy);

/** memory-mapping function used with delete() operator
@param Memory Pointer to allocated memory
*/
void operator delete(void* Memory) throw();

/** memory-mapping function used with delete[] operator
@param Memory Pointer to allocated memory
*/
void operator delete[](void* Memory) throw();

#define new new(0)
#define delete CustomMemoryMapping_delete(0),delete
#define malloc(x) CustomMemoryMapping_malloc(x,0)
#define free(x) CustomMemoryMapping_free(x,0)
#define realloc(x,y) CustomMemoryMapping_realloc(x,y,0)

#endif //#ifdef eC_CUSTOM_MEMORY_MAPPING
