
#
# Windows-MSVC-x86.cmake settings file
#

# set output dirs
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES LIBRARY_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")
SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES ARCHIVE_OUTPUT_DIRECTORY "${PROJECT_SOURCE_DIR}/Libraries/${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_ARCH}/${CMAKE_CXX_COMPILER_ID}")

FILE(GLOB EC_PLATFORM_X86WIN32_CPP "${PROJECT_SOURCE_DIR}/comps/eC/code/x86_win32/*.cpp")
IF(EGAC_BUILD_EGML)
  FILE(GLOB EGML_PLATFORM_GDI_CPP "${PROJECT_SOURCE_DIR}/comps/eGML/code/eGML_GDI/*.cpp")
ENDIF(EGAC_BUILD_EGML)

IF(EGAC_BUILD_IMAGELIBS)
  TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Gif"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/Jpeg/decompression"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/png"
    PRIVATE "${PATH_EGAC}/intfs/ImageLibs/zlib"
  )
ELSE(EGAC_BUILD_IMAGELIBS)
  IF(LIBS_BUILD_LIBJPEG)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBJPEG}"
    )
  ELSE(LIBS_BUILD_LIBJPEG)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/jpeg"
    )
  ENDIF(LIBS_BUILD_LIBJPEG)

  IF(LIBS_BUILD_LIBPNG)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBPNG}"
    )
  ELSE(LIBS_BUILD_LIBPNG)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/png/lpng1636"
    )
  ENDIF(LIBS_BUILD_LIBPNG)

  # if zlib if built include-file is located in build-folder
  IF(NOT LIBS_BUILD_ZLIB)
    TARGET_INCLUDE_DIRECTORIES(${PROJECT_NAME}
      PRIVATE "${PATH_LIBS}/zlib/include"
    )
  ENDIF(NOT LIBS_BUILD_ZLIB)

  LIST(APPEND PLATFORM_DEFINES "XMD_H;NEED_FAR_POINTERS;ZLIB_WINAPI")
ENDIF(EGAC_BUILD_IMAGELIBS)

SET(EGAC_PLATFORM_FILES 
  ${EC_PLATFORM_X86WIN32_CPP}
  ${EGML_PLATFORM_GDI_CPP}
)
