/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

#include "StreamRuntimeStartup.h"
#include "Resource.h"

// needs to be included to avoid unresolved references to memleak
#include "GUIMemLeakFunctions.h"

#include "GUIResourceFileHandler.h"
#include "GUILocalisationHandler.h"
#include "GUITrace.h"
#include "GUIException.h"
#include "GUI.h"

#include "GUIAutoPtr.h"

// Includes for wrapper classes
#include "SndWrapWin.h"
#include "FntWrapWin.h"
#include "GUIInputWindows.h"
#include "GUIPlaybackInput.h"

#if defined GFX_USE_GDI
    #include "GfxWrapGDIPC.h"
#elif defined GFX_USE_EGML
    #include "GfxWrapeGMLwin.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeeGML.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibeGML.h"
    #endif
    #if defined GFX_USE_DCWRAP
        #include "DCWrap.h"
    #endif
#elif defined GFX_USE_DAVE
    #include "GfxWrapDAVEWin.h"

    #if defined GFX_USE_DCWRAP
        #include "DCWrapDAVE.h"
    #endif

    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeDaveUnCached.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibDaveUnCached.h"
    #endif
#elif defined GFX_USE_GL
    #include "GfxWrapOGLwin.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeGL.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibGL.h"
    #endif
    #if defined GFX_USE_DCWRAP
        #error "DC-Wrap not available"
    #endif
#elif defined GFX_USE_BLU
    #include "GfxWrapBLUwin.h"
    #if defined FNT_USE_FREETYPE
        #include "FntWrapFreeTypeBLU.h"
    #elif defined FNT_USE_GLYPHLIB
        #include "FntWrapGlyphLibBLU.h"
    #endif
    #if defined GFX_USE_DCWRAP
        #error "DC-Wrap not available"
    #endif
#else
    #include "GfxWrapNull.h"
#endif

#if defined(GFX_USE_DAVE) || defined(GFX_USE_GL) || defined(GFX_USE_BLU)
#ifdef GUILIANI_ADD_IMAGE_DECODER
    #include "GUIImageLoader.h"
    #include "GUIImageDecoderBLU.h"
    #include "GUIImageDecoderBMP.h"
    #include "GUIImageDecoderPNG.h"
    #include "GUIImageDecoderJPG.h"
    #include "GUIImageDecoderRAW.h"
    #include "GUIImageDecoderRLE.h"
    #include "GUIImageDecoderSVG.h"
#else
#error "Guiliani is built without Imageloaders. Image will not be loaded correctly."
#endif
#endif

#include "GUIMemLeakWatcher.h"

// User configurable values for the application window position:
static const eC_UInt cuiWINDOWPOS_X = 0;
static const eC_UInt cuiWINDOWPOS_Y = 0;

// Window related variables
static const eC_UInt cuiMAX_LOADSTRING = 100;
static TCHAR szTitle[cuiMAX_LOADSTRING];                // Caption (title bar) text
static TCHAR szWindowClass[cuiMAX_LOADSTRING];

/*
Startup sequence is:
    Init()
    MyRegisterClass()
    OpenWindow()
    ConstructWrapperClasses()
    <--- Application lifetime --->
    DestructWrapperClasses()
*/

#if defined GFX_USE_DCWRAP

// 4 example layers

#define LAYER1_WIDTH 160
#define LAYER1_HEIGHT 120
#define LAYER1_STRIDE LAYER1_WIDTH * 4
#define LAYER1_BUFFER_NUM 2

#define LAYER2_WIDTH 160
#define LAYER2_HEIGHT 120
#define LAYER2_STRIDE LAYER2_WIDTH * 2
#define LAYER2_BUFFER_NUM 2

#define LAYER3_WIDTH 160
#define LAYER3_HEIGHT 120
#define LAYER3_STRIDE LAYER3_WIDTH * 2
#define LAYER3_BUFFER_NUM 2

#define LAYER4_WIDTH 160
#define LAYER4_HEIGHT 120
#define LAYER4_STRIDE LAYER4_WIDTH * 2
#define LAYER4_BUFFER_NUM 2

#endif

// Namespace containing default implementations for initializing a StreamRuntime under windows
namespace NStreamRuntime
{
    void CStreamRuntimeStartup::ConstructWrapperClasses()
    {
#if defined GFX_USE_DCWRAP
#if defined GFX_USE_DAVE
        // create dc-wrapper using D/AVE d1_XXX-functions
        CDCWrapDAVE::CreateInstance(GetScreenWidth(), GetScreenHeight());
#elif defined GFX_USE_EGML
        // create dc-wrapper for basic functionality
        CDCWrap::CreateInstance(GetScreenWidth(), GetScreenHeight());
#endif

#if defined GFX_USE_DAVE || defined GFX_USE_EGML
        LayerConfiguration_t kLayer0;
        kLayer0.m_uiLayerID = 0;
        kLayer0.m_bMainLayer = true;
        kLayer0.m_uiWidth = GetScreenWidth();
        kLayer0.m_uiHeight = GetScreenHeight();
        kLayer0.m_uiPaddedWidth = GetScreenWidth();
        kLayer0.m_ePixFormat = LPF_RGBA8888;
        kLayer0.m_uiNumBuffers = 1;
        kLayer0.m_bVisible = true;
        kLayer0.m_bCached = true;

        LayerConfiguration_t kLayer1;
        kLayer1.m_uiLayerID = 1;
        kLayer1.m_uiWidth = LAYER1_WIDTH;
        kLayer1.m_uiHeight = LAYER1_HEIGHT;
        kLayer1.m_uiPaddedWidth = LAYER1_WIDTH;
        kLayer1.m_ePixFormat = LPF_RGB565;
        kLayer1.m_uiNumBuffers = LAYER1_BUFFER_NUM;

        LayerConfiguration_t kLayer2;
        kLayer2.m_uiLayerID = 2;
        kLayer2.m_uiWidth = LAYER2_WIDTH;
        kLayer2.m_uiHeight = LAYER2_HEIGHT;
        kLayer2.m_uiPaddedWidth = LAYER2_WIDTH;
        kLayer2.m_ePixFormat = LPF_RGB565;
        kLayer2.m_uiNumBuffers = LAYER2_BUFFER_NUM;

        LayerConfiguration_t kLayer3;
        kLayer3.m_uiLayerID = 3;
        kLayer3.m_uiWidth = LAYER3_WIDTH;
        kLayer3.m_uiHeight = LAYER3_HEIGHT;
        kLayer3.m_uiPaddedWidth = LAYER3_WIDTH;
        kLayer3.m_ePixFormat = LPF_RGB565;
        kLayer3.m_uiNumBuffers = LAYER3_BUFFER_NUM;

        LayerConfiguration_t kLayer4;
        kLayer4.m_uiLayerID = 4;
        kLayer4.m_uiWidth = LAYER4_WIDTH;
        kLayer4.m_uiHeight = LAYER4_HEIGHT;
        kLayer4.m_uiPaddedWidth = LAYER4_WIDTH;
        kLayer4.m_ePixFormat = LPF_RGB565;
        kLayer4.m_uiNumBuffers = LAYER4_BUFFER_NUM;

        GETDC.AddLayer(kLayer0);
        GETDC.AddLayer(kLayer1);
        GETDC.AddLayer(kLayer2);
        GETDC.AddLayer(kLayer3);
        GETDC.AddLayer(kLayer4);
#endif

#endif

// Sets the graphics wrapper and font wrapper
#if defined GFX_USE_GDI
    CGfxWrapGDIPC::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight());
    CFntWrapWin::CreateInstance(((CGfxWrapGDIPC&)GETGFX).GetScreen());
#elif defined GFX_USE_EGML
    #if defined GFX_USE_DCWRAP
        CGfxWrapeGMLwin::CreateInstance(m_hWnd, &GETDC);
    #else
        #if defined GFX_USE_ARGB32
            CGfxWrapeGMLwin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), 32);
        #elif defined GFX_USE_RGB565
            CGfxWrapeGMLwin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), 16);
        #else
            #error "Please choose supported color-format"
        #endif
    #endif

    #if defined FNT_USE_FREETYPE
            CFntWrapFreeTypeeGML::CreateInstance(1024 * 1024, static_cast<CGfxWrapeGML&>(GETGFX).GetScreen());
    #elif defined FNT_USE_GLYPHLIB
            CFntWrapGlyphLibeGML::CreateInstance(static_cast<CGfxWrapeGML&>(GETGFX).GetScreen());
    #endif
#elif defined GFX_USE_GL
        CGfxWrapOGLwin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight());
#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeGL::CreateInstance();
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibGL::CreateInstance();
#endif
#elif defined GFX_USE_DAVE
    #if defined GFX_USE_DCWRAP
        CGfxWrapDAVEWin::CreateInstance(m_hWnd, &GETDC);
    #else
        #if defined GFX_USE_ARGB32
            CGfxWrapDAVEWin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), d1_mode_argb8888, d2_mode_argb8888, 4);
        #elif defined GFX_USE_RGB565
            CGfxWrapDAVEWin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), d1_mode_rgb565, d2_mode_rgb565, 2);
        #else
            #error "Please choose supported color-format"
        #endif
    #endif
#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeDAVEUncached::CreateInstance(1024 * 1024, static_cast<CGfxWrapDAVE&>(GETGFX).GetDaveDevice());
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibDAVEUncached::CreateInstance(static_cast<CGfxWrapDAVE&>(GETGFX).GetDaveDevice());
#endif
#elif defined GFX_USE_BLU
    #if defined GFX_USE_ARGB32
        CGfxWrapBLUwin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), 32);
    #elif defined GFX_USE_RGB565
        CGfxWrapBLUwin::CreateInstance(m_hWnd, GetScreenWidth(), GetScreenHeight(), 16);
    #else
        #error "Please choose supported color-format"
    #endif
#if defined FNT_USE_FREETYPE
        CFntWrapFreeTypeBLU::CreateInstance(1024 * 1024);
#elif defined FNT_USE_GLYPHLIB
        CFntWrapGlyphLibBLU::CreateInstance();
#endif
#else
        MessageBox(NULL, TEXT("Please choose a Graphics-Wrapper. Defaulting to CGfxWrapNull."), TEXT("Warning"), 0);
        CGfxWrapNull::CreateInstance();
#endif

#if defined(GFX_USE_DAVE) || defined(GFX_USE_GL)
    #ifdef GUILIANI_ADD_IMAGE_DECODER
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderBMP());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderBLU());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderPNG());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderJPG());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderRAW());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderRLE());
            GETIMGLOADER.AddDecoder(new CGUIImageDecoderSVG());
    #endif
#endif

        // Sets the sound wrapper
        CSndWrapWin::CreateInstance();
        // Sets the input wrapper
        CGUIInputWindows::CreateInstance(m_hWnd);
    }

    /* ---------------------------------------------------------------------------------
    Everything below is plain Windows-Code for setting up the application window
    ---------------------------------------------------------------------------------  */
    void CStreamRuntimeStartup::Init(HINSTANCE hInstance, int nCmdShow)
    {
        m_hInstance = hInstance;
        // Load some global strings from programs resource chunk
        LoadString(hInstance, IDS_APP_TITLE, szTitle, cuiMAX_LOADSTRING);
        LoadString(hInstance, IDC_APP_WCLASS, szWindowClass, cuiMAX_LOADSTRING);

        MyRegisterClass();

        if (!OpenWindow(nCmdShow))
            GUILOG_THROW_EXCEPTION(CGUIException(), "NStreamRuntime::Init: Could not initialize application.\n");
    }

    ATOM CStreamRuntimeStartup::MyRegisterClass()
    {
        WNDCLASSEX wcex;
        wcex.cbSize = sizeof(WNDCLASSEX);
        wcex.style = 0;
        wcex.lpfnWndProc = (WNDPROC)WndProc;
        wcex.cbClsExtra = 0;
        wcex.cbWndExtra = 0;
        wcex.hInstance = m_hInstance;
        wcex.hIcon = LoadIcon(m_hInstance, (LPCTSTR)IDI_APP_ICON);
        wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcex.hbrBackground = NULL;
        wcex.lpszMenuName = NULL;
        wcex.lpszClassName = szWindowClass;
        wcex.hIconSm = LoadIcon(wcex.hInstance, (LPCTSTR)IDI_APP_ICON_SMALL);

        return RegisterClassEx(&wcex);
    }

    BOOL CStreamRuntimeStartup::OpenWindow(int nCmdShow)
    {
        // Used for client area
        RECT aRect;
        SetRect(&aRect, 0, 0, GetScreenWidth(), GetScreenHeight());

        // Adjust the window size based on desired client area
        DWORD dwStyle = WS_SYSMENU | WS_CAPTION | WS_VISIBLE;

        if (IsWindowResizable())
        {
            //Resizable window;
            dwStyle |= WS_SIZEBOX;
        }

        AdjustWindowRect(&aRect, dwStyle, false);

        m_hWnd = CreateWindow(
            szWindowClass, szTitle, dwStyle,
            cuiWINDOWPOS_X, cuiWINDOWPOS_Y, aRect.right - aRect.left, aRect.bottom - aRect.top,
            NULL, NULL, m_hInstance, NULL);

        if (!m_hWnd)
        {
            return FALSE;
        }

        eC_Int caps;
        caps = GetDeviceCaps(GetDC(m_hWnd), BITSPIXEL);

        if (caps != 32 && caps != 16) // 16 or 32 Bit are the recommended color depth for windows
        {
            GUILOG(GUI_TRACE_WARNING, "Please choose a color depth of 16 or 32-Bit. \n");
        }

        ShowWindow(m_hWnd, nCmdShow);
        UpdateWindow(m_hWnd);
        return TRUE;
    }

    // Processes some of the windows OS messages that are sent to this application window.
    LRESULT CALLBACK CStreamRuntimeStartup::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
        switch (message)
        {
            case WM_PAINT:
            {
                PAINTSTRUCT ps;
                BeginPaint(hWnd, &ps);
                if (CGUI::IsCreated())
                {
                    // Trigger redraw of the GUI
                    GETGFX.InvalidateRect(
                        eC_FromInt(ps.rcPaint.left),
                        eC_FromInt(ps.rcPaint.top),
                        eC_FromInt(ps.rcPaint.right),
                        eC_FromInt(ps.rcPaint.bottom));
                }
                EndPaint(hWnd, &ps);
                break;
            }

            case WM_SIZE:
            {
                if (CGUI::IsCreated())
                {
                    GETGUI.SetWidth(eC_FromInt(LOWORD(lParam)));
                    GETGUI.SetHeight(eC_FromInt(HIWORD(lParam)));
                    GETGFX.SetScreenSize(LOWORD(lParam), HIWORD(lParam));

                    RECT rect;
                    GetClientRect(hWnd, &rect);
                    InvalidateRect(hWnd, &rect, FALSE);
                }
            }
            break;

            case WM_DESTROY:
                PostQuitMessage(0);
                break;

            default:
                return DefWindowProc(hWnd, message, wParam, lParam);
        }
        return 0;
    }

    void CStreamRuntimeStartup::UpdateWindowTitle()
    {
        // display version and license-type in window-titlebar
        eC_String kText = "Guiliani " + CGUI::GetVersionString() + " (" + CGUI::GetPlatformString() + "/" + GETGFX.GetWrapperName() + ") -" + CGUI::GetLicenseString();
        CGUIAutoPtr<eC_TChar> pcCaption(kText.ToTChar_Alloc(), true);

        SetWindowText(GetWindow(), pcCaption.get());
    }
}
