#include "ExampleTextType.h"

#include "CustomExtensionFactory.h"

#ifdef GUILIANI_STREAM_GUI
#include "GUIStreamReader.h"
#endif

#ifdef GUILIANI_WRITE_GUI
#include "GUIStreamWriter.h"
#include "GUITextResource.h"
#endif

#include "GUICompositeObject.h"
#include "GfxWrap.h"

#include "GUIMemLeakWatcher.h" // <-- has to be the last include

#define EXAMPLE_TEXTTYPE_CLASS_VERSION 1
// The minimal class version allowed.
#define EXAMPLE_TEXTTYPE_CLASS_MIN_VERSION 1

// CGUIExampleLayouter
static const eC_Int TEXTTYPE_EXAMPLE_UID = 0x1337DEAD;

eC_Bool ExampleTextType::ms_bInitialized = GETEXTENSIONSFACTORY->RegisterText(TextTypeDescriptor(TEXTTYPE_EXAMPLE_UID, "Custom Texttype", ExampleTextType::Create));

ExampleTextType::ExampleTextType(
    CGUICompositeObject *const pParent,
    const eC_Value &vX, const eC_Value &vY,
    const eC_String& kText) :
    CGUIText(pParent, kText, vX, vY)
{
    SetXMLTag("ExampleTextType");
}

#if defined(GUILIANI_STREAM_GUI)
void ExampleTextType::ReadFromStream()
{
    /* const eC_UInt cuiVersion =*/ ReadStreamingHeader(EXAMPLE_TEXTTYPE_CLASS_VERSION, EXAMPLE_TEXTTYPE_CLASS_MIN_VERSION);

    // always base-class first
    CGUIText::ReadFromStream();

    if (NULL != GetContainingObject())
    {
        SetTextWidth(GetContainingObject()->GetWidth());
        SetTextHeight(GetContainingObject()->GetHeight());
    }
    SetTextColorStandard(0xffff0000);
    SetAlignedHorizontal(CGUIText::H_CENTERED);
    SetAlignedVertical(CGUIText::V_CENTERED);
}
#endif

#if defined(GUILIANI_WRITE_GUI)
void ExampleTextType::WriteToStream(const eC_Bool bWriteClassID)
{
    WriteStreamingHeader(bWriteClassID, XMLTAG_TEXTTYPEID, TEXTTYPE_EXAMPLE_UID, EXAMPLE_TEXTTYPE_CLASS_VERSION);

    CGUIText::WriteToStream();

    WriteStreamingFooter(bWriteClassID);
}
#endif
