#include "CustomExtensionFactory.h"

#include "GUIMemLeakWatcher.h"
#include "WindowsLeakWatcher.h"

CustomExtensionFactory* CustomExtensionFactory::ms_pkInstance = NULL;

CustomExtensionFactory::CustomExtensionFactory()
{
}

CustomExtensionFactory::~CustomExtensionFactory()
{
}

CustomExtensionFactory* CustomExtensionFactory::GetInstance()
{
    if (ms_pkInstance == NULL)
    {
        ms_pkInstance = new CustomExtensionFactory();
    }
    return ms_pkInstance;
}

// create-methods
CGUIObject* CustomExtensionFactory::CreateControl(ControlClassID_t eControlID)
{
    CGUIObject* pkNewObject = NULL;

    ControlCallbackMap::iterator it = m_kControlMap.find(eControlID);
    if (it != m_kControlMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewObject = (it->second).m_pkCreate();
    }
    return pkNewObject;
}

CGUIBehaviourDecorator* CustomExtensionFactory::CreateBehaviour(BehaviourClassID_t eBehaviourID)
{
    CGUIBehaviourDecorator* pkNewBehaviour = NULL;

    BehaviourCallbackMap::iterator it = m_kBehaviourMap.find(eBehaviourID);
    if (it != m_kBehaviourMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewBehaviour = (it->second).m_pkCreate();
    }
    return pkNewBehaviour;
}

CGUICommand* CustomExtensionFactory::CreateCommand(CommandClassID_t eCommandID)
{
    CGUICommand* pkNewCommand = NULL;

    CommandCallbackMap::iterator it = m_kCommandMap.find(eCommandID);
    if (it != m_kCommandMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewCommand = (it->second).m_pkCreate();
    }
    return pkNewCommand;
}

CGUILayouter* CustomExtensionFactory::CreateLayouter(LayouterClassID_t eLayouterID)
{
    CGUILayouter* pkNewLayouter = NULL;

    LayouterCallbackMap::iterator it = m_kLayouterMap.find(eLayouterID);
    if (it != m_kLayouterMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewLayouter = (it->second).m_pkCreate();
    }
    return pkNewLayouter;
}

CGUIText* CustomExtensionFactory::CreateText(TextTypeID_t eTextType)
{
    CGUIText* pkNewText = NULL;

    TextCallbackMap::iterator it = m_kTextMap.find(eTextType);
    if (it != m_kTextMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewText = (it->second).m_pkCreate();
    }
    return pkNewText;
}

#ifdef GUILIANI_ANIMATION_ACTIVE
CGUIAnimation* CustomExtensionFactory::CreateAnimation(AnimationType_t eAnimation)
{
    CGUIAnimation* pkNewAnimation = NULL;

    AnimationCallbackMap::iterator it = m_kAnimationMap.find(eAnimation);
    if (it != m_kAnimationMap.end())
    {
        // call the creation callback to construct this derived type
        pkNewAnimation = (it->second).m_pkCreate();
    }
    return pkNewAnimation;
}
#endif
