/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#if !defined(STREAMRUNTIMEGUI_H)
#define STREAMRUNTIMEGUI_H

#include "GUI.h"
#include "GUIRefCntPtr.h"

#ifdef GUILIANI_STREAM_GUI
#include "GUIStreamReader.h"
#endif

#include "GUIAutoPtr.h"

#include "GUIEvent.h"

/** The NStreamRuntime Namespace contains generic helper classes for initializing a default StreamRuntime application.
The code herein typically remains widely unchanged across most StreamRuntimes.
Feel free to remove these classes from your own application and replace them with custom code, if you wish.*/
namespace NStreamRuntime
{

    /** StreamRuntime specific CGUI instance.
    Serves as a base-class for the application implemented by customer. */
    class CStreamRuntimeGUI : public CGUI
    {
    public:
        CStreamRuntimeGUI(eC_Value x, eC_Value y, eC_Value width, eC_Value height, ObjectHandle_t eID);
        virtual ~CStreamRuntimeGUI();

        /** Default initialization routine which reads configuration data from the config XML file and
        initializes Guiliani accordingly */
        void Init();

        void StreamGUI();

        /// fills the application background with a rectangle in the color read from the config XML file.
        virtual eC_Bool DoDraw();

        virtual eC_Bool DoKeyDown(const GUIKeyIdentifier_t& eKeyID, const eC_UInt& uiModifiers);

        void EnableScreenshot(
            const eC_String& kScreenshotPrefix = "screenshot",
            const GUIKeyIdentifier_t& eScreenshotKey = GK_S,
            const eC_UInt& uiScreeenshotModifier = CGUIEvent::GKM_CONTROL);

    private:
        eC_Bool m_bScreenshotActive;
        eC_String m_kScreenshotPrefix;
        GUIKeyIdentifier_t m_eScreenshotKey;
        eC_UInt m_uiScreenshotModifier;

#ifdef GUILIANI_STREAM_GUI
        /// Streamreader used by the StreamRuntime during startup. The config file specifies which type of reader to use.
        CGUIAutoPtr<CGUIStreamReader> m_pkStreamReader;
#endif
    };
}
#endif
