/*
* Copyright (C) 2004 TES Electronic Solutions GmbH,
* All Rights Reserved.
* This source code and any compilation or derivative thereof is the
* proprietary information of TES Electronic Solutions GmbH
* and is confidential in nature.
* Under no circumstances is this software to be exposed to or placed
* under an Open Source License of any type without the expressed
* written permission of TES Electronic Solutions GmbH
*
*############################################################
*/

/******************************************************************************
*   PROJECT:        Guiliani
*******************************************************************************
*
*    MODULE:        MyGUI_SR.cpp
*
*    Archive:       $URL: https://10.25.129.51:3690/svn/GSE/branches/Releases/1.0_Guiliani_2.1/StreamRuntime/src/MyGUI_SR.cpp $
*
*    Date created:  2005
*
*
*
*    Author:        JRE
*
*******************************************************************************
*   MODIFICATIONS
*******************************************************************************
*    ID
*    --------------------------------------------------------------------------
*    $Id: MyGUI_SR.cpp 2159 2014-11-26 15:36:46Z christian.euler $
*
******************************************************************************/
#include "MyGUI_SR.h"

#include "GUIResourceFileHandler.h"

#include "GUI.h"
#include "GUIDataPool.h"
#include "GUIButton.h"
#include "GUIBaseTextField.h"
#include "GUICarousel.h"
#include "GUITextField.h"
#include "GUILocalisationHandler.h"
#include "GUISlider.h"
#include "GUIScrollingTextField.h"
#include "GUIGeometryObject.h"
#include "GUIBaseMessageBox.h"
#include "GUISwitchResourceSetsCmd.h"

#include "GUICommandHandler.h"
#include "GUIEventHandler.h"
#include "GUIPlaybackInput.h"
#include "GUIProperties.h"

#include "GfxWrap.h"

#include "GUIAnimationMove.h"
#include "GUIAnimationSize.h"
#include "GUIAnimationObserver.h"
#include "GUIStartAnimationChainCmd.h"
#include "GUIStopAnimationChainCmd.h"
#include "GUIAnimationResource.h"

#include "GUIBehaviourDecorator.h"

#include "GUIBiDiHelper.h"

#ifdef GFX_USE_EGML
#include "GfxWrapeGML.h"
#endif

#include "StreamRuntimeConfig.h"
#include "GUIFramerate.h"

#include "GUIStreamReaderXML.h"
#include "GUIStreamWriterXML.h"
#include "GUIStreamWriterBinary.h"

// dialogs
#include "DemoAdvanced.h"
#include "DemoAnimation.h"
#include "DemoControls.h"
#include "DemoContainer.h"
#include "DemoData.h"
#include "DemoKeyboard.h"
#include "DemoLayer.h"
#include "DemoSettings.h"

#include "GUIImage.h"

#include "GUIMemProfile.h"

#include "GUIMemLeakDetection.h"

// LAST INCLUDE!!
#include "GUIMemLeakWatcher.h"

const eC_String CMyGUI::DIALOG_NAME_MAIN = "Main";
const eC_String CMyGUI::DIALOG_NAME_ADVANCED = "Advanced";
const eC_String CMyGUI::DIALOG_NAME_ANIMATION = "Animation";
const eC_String CMyGUI::DIALOG_NAME_CONTAINER = "Container";
const eC_String CMyGUI::DIALOG_NAME_CONTROLS = "Controls";
const eC_String CMyGUI::DIALOG_NAME_DATA = "Data";
const eC_String CMyGUI::DIALOG_NAME_KEYBOARD = "Keyboard";
const eC_String CMyGUI::DIALOG_NAME_LAYER = "Layer";
const eC_String CMyGUI::DIALOG_NAME_SCRATCHPAD = "Scratchpad";
const eC_String CMyGUI::DIALOG_NAME_SETTINGS = "Settings";

class PullBehaviour : public CGUIBehaviourDecorator
{
public:
    PullBehaviour() :
        CGUIBehaviourDecorator()
    {}

    virtual eC_Bool DoButtonDown(
        const eC_Value &vAbsX,
        const eC_Value &vAbsY)
    {
        if (NULL != GetAssociatedObject())
        {
            m_vStartX = GetAssociatedObject()->GetRelXPos();
            m_vStartY = GetAssociatedObject()->GetRelYPos();
            m_vOffsetX = vAbsX - GetAssociatedObject()->GetAbsXPos();
            m_vOffsetY = vAbsY - GetAssociatedObject()->GetAbsYPos();
        }
        return true;
    }

    virtual eC_Bool DoButtonUp(
        const eC_Value &vAbsX,
        const eC_Value &vAbsY)
    {
        if (NULL != GetAssociatedObject())
        {
            CGUIAnimationMove* pkMove = new CGUIAnimationMove(
                GetAssociatedObject(),
                CGUIEasing::EASE_OUT_BOUNCE, CGUIEasing::EASE_OUT_BOUNCE,
                eC_FromInt(0), eC_FromInt(0),
                m_vStartX, m_vStartY, 500,
                true);
            pkMove->SetDeletedAfterFinish(true);
            pkMove->StartAnimation();
        }
        return true;
    }

    virtual eC_Bool DoDrag(
        const eC_Value &vDeltaX,
        const eC_Value &vDeltaY,
        const eC_Value &vAbsX,
        const eC_Value &vAbsY)
    {
        if (NULL != GetAssociatedObject())
        {
            GetAssociatedObject()->InvalidateArea();
            GetAssociatedObject()->SetRelXPos(vAbsX - GetAssociatedObject()->GetParent()->GetAbsXPos() - m_vOffsetX);
            GetAssociatedObject()->SetRelYPos(vAbsY - GetAssociatedObject()->GetParent()->GetAbsYPos() - m_vOffsetY);
            GetAssociatedObject()->InvalidateArea();
        }
        return true;
    }

    virtual eC_Bool DoDragEnd(
        const eC_Value &vAbsX,
        const eC_Value &vAbsY)
    {
        return DoButtonUp(vAbsX, vAbsY);
    }

private:
    eC_Value m_vStartX;
    eC_Value m_vStartY;
    eC_Value m_vOffsetX;
    eC_Value m_vOffsetY;
};

//---------------------------------------------------------------
//Text Animation
//---------------------------------------------------------------
TextAnimation::TextAnimation(eC_UByte ubStartVal, eC_UByte ubEndVal) :
    m_pkTextField(NULL),
    m_ubStartVal(ubStartVal),
    m_ubEndVal(ubEndVal)
{
    m_pkTextField = static_cast<CGUITextField*>(GETGUI.GetObjectByID(INFO_TEXT));
    GETTIMER.AddAnimationCallback(40, this);
    m_uiCalc = m_ubStartVal;
}

TextAnimation::~TextAnimation()
{
    GETTIMER.RemoveAnimationCallback(this);
    m_pkTextField = NULL;
}

void TextAnimation::DoAnimate(const eC_Value &vTimes)
{
    m_uiCalc += 16;
    if (m_uiCalc >= m_ubEndVal)
    {
        m_uiCalc = m_ubEndVal;
        GETTIMER.RemoveAnimationCallback(this);
    }

    if (NULL != m_pkTextField)
    {
        m_pkTextField->SetAlpha(eC_UByte(m_uiCalc));
        m_pkTextField->InvalidateArea();
    }
}

//---------------------------------------------------------------
//Box Observer
//---------------------------------------------------------------
BoxObserver::BoxObserver(eC_Bool bShow) :
    m_bShow(bShow),
    m_pkTextAnimation(NULL)
{
    m_pkTextAnimation = NULL;
}

BoxObserver::~BoxObserver()
{
    if (m_pkTextAnimation != NULL)
    {
        delete m_pkTextAnimation;
        m_pkTextAnimation = NULL;
    }
}

/*Checks if the animation on the dialog is running*/
void BoxObserver::OnStatusChanged(CGUIAnimation::AnimationStatus_t eStatus, CGUIAnimation* pkAnimation)
{
    if (eStatus == CGUIAnimation::ANIMATION_FINISHED)
    {
        if (m_bShow == true)
        {
            m_pkTextAnimation = new TextAnimation(0, 255);
        }
        else
        {
            m_pkTextAnimation = new TextAnimation(255, 0);
        }
        GETGUI.InvalidateChildren();
    }
}

CMyGUI::CMyGUI(
    eC_Value x, eC_Value y,
    eC_Value width, eC_Value height,
    ObjectHandle_t eID) :
    CStreamRuntimeGUI(x, y, width, height, eID),
    m_pkDialogAdvanced(NULL),
    m_pkDialogAnimation(NULL),
    m_pkDialogContainer(NULL),
    m_pkDialogControls(NULL),
    m_pkDialogData(NULL),
    m_pkDialogKeyboard(NULL),
    m_pkDialogLayer(NULL),
    m_pkDialogSettings(NULL),
    m_pkBoxObserver(NULL),
    m_eTransitionType(CGUITransitionCmd::PUSH_FROM_TOP),
    m_eBackgroundImage(IMG_GUILIANI_DEMO_BACKGROUND_NATIVE),
    m_eGaugeEasingType(CGUIEasing::EASE_IN_OUT_SINE),
    m_eSelectedMenu(MENU_ANIMATION),
    m_uiBackgroundColor(0XFFF5F5F4),
    m_eImageMode(DemoSettings::IM_LIGHT_MODE),
    m_eActiveLanguage(DemoSettings::ENGLISH),
    m_pkGlassPane(NULL),
    m_uiCurrentTime((6 * 60 + 30) * 60),
    m_uiCurrentIdleTime(0)
{
    srand(GETTIMER.GetTime());

    // Add application specific initialisation here if necessary
    GETEVENTHDL.SetDragThreshold(40);

    // set deletion-policy to stop
    GETANIMATIONHDL.SetDeletionPolicy(CGUIAnimationHandler::DP_STOP);

    // init "demo"-mode
    CGUIPlaybackInput::CreateInstance(false, "other_resources/EventRecord.dat");

    // set background-image for target-platform
#if defined(GFX_USE_DAVE) || defined(GFX_USE_BLU)
    m_eBackgroundImage = IMG_GUILIANI_DEMO_BACKGROUND_RAW;
#elif defined(GFX_USE_EGML)
    m_eBackgroundImage = IMG_GUILIANI_DEMO_BACKGROUND_NATIVE;
#else
    m_eBackgroundImage = IMG_GUILIANI_DEMO_BACKGROUND_RLE;
#endif

    // get object-id of first child to determine starting dialog and init
    ObjectHandle_t eStartDialog = NO_HANDLE;
    if (GetNumberOfChildren() > 0)
        eStartDialog = GetChild(0)->GetID();
    InitDialog(eStartDialog);

#if 0
    // do not use glasspane due to problems with alpha-transparency on rectangles
#if !defined(eC_TARGET_ENV_STM32F429) && !defined(eC_TARGET_ENV_STM32F746)
    m_pkGlassPane = new CGUIGeometryObject(this, eC_FromInt(0), eC_FromInt(0), this->GetWidth(), this->GetHeight(), 0xff000000, CGUIGeometryObject::PS_RECTANGLE, eC_FromInt(1), true);
    m_pkGlassPane->SetAlpha(127);
    m_pkGlassPane->SetInvisible(true);
#endif

#endif

    // init text for sub-menus
    MenuTexts[0] = ANIMATION_BUTTON_TXT;
    MenuTexts[1] = BUTTONS_BUTTON_TXT;
    MenuTexts[2] = ADVANCED_BUTTON_TXT;
    MenuTexts[3] = DUMMY_TEXT;
    MenuTexts[4] = GAUGE_N_WHEEL_BUTTON_TEXT;
    MenuTexts[5] = CAROUSEL_BUTTON_TXT;
    MenuTexts[6] = KEYBOARD_TXT;
    MenuTexts[7] = SCRATCHPAD_TXT;
    MenuTexts[8] = SETTINGS_BUTTON_TXT;

    eC_Value vFPSPosX = eC_FromInt(0);
    eC_Value vFPSPosY = eC_FromInt(0);

    if (GetWidth() == eC_FromInt(800))
    {
        vFPSPosX = eC_FromInt(70);
        vFPSPosY = eC_FromInt(5);
    }
    else if (GetWidth() == eC_FromInt(480))
    {
        vFPSPosX = eC_FromInt(40);
        vFPSPosY = eC_FromInt(0);
    }

#if 1
    GETFPS.SetInvisible(true);
    GETFPS.SetPosition(CGUIFramerate::DEFAULT_ABS_FPS, vFPSPosX, vFPSPosY);
    GETFPS.SetBackColor(CGUIFramerate::DEFAULT_ABS_FPS, 0xffffffff);
    GETFPS.SetTextColor(CGUIFramerate::DEFAULT_ABS_FPS, 0xffdd0000);
    GETFPS.SetFont(CGUIFramerate::DEFAULT_ABS_FPS, FNT_BEBASNEUE_BOLD);

    GETFPS.SetPosition(CGUIFramerate::DEFAULT_FPS, vFPSPosX, vFPSPosY + eC_FromInt(10));
    GETFPS.SetBackColor(CGUIFramerate::DEFAULT_FPS, 0xffffffff);
    GETFPS.SetTextColor(CGUIFramerate::DEFAULT_FPS, 0xffdd0000);
    GETFPS.SetFont(CGUIFramerate::DEFAULT_FPS, FNT_BEBASNEUE_BOLD);
#endif

    // starting-time of application
    m_uiCurrentIdleTime = GETTIMER.GetTime();

    CGUIBiDiHelper::SetActive(true);

    // auto create datapool for controls-dialog
    DataPoolResource_t eDataPoolID = CGUIDataPool::RegisterDynamicDataPoolResource();
    CGUIDataPool::AutoRegister(eDataPoolID, OBJ_SEGMENT_BAR);
    CGUIDataPool::AutoRegister(eDataPoolID, OBJ_RADIAL_SLIDER);
}

CMyGUI::~CMyGUI()
{
    // Add application specific de-initialisation here if necessary
    Cleanup();
}

void CMyGUI::SetTransition(const eC_String& kText)
{
    // this also sets the origin menu-item
    if (kText == "Advanced")
    {
        SetTransition(OBJ_ADVANCED_BUTTON);
        m_eSelectedMenu = MENU_ADVANCED;
    }
    else if (kText == "Animation")
    {
        SetTransition(OBJ_DYNAMICS_BUTTON);
        m_eSelectedMenu = MENU_ANIMATION;
    }
    else if (kText == "Container")
    {
        SetTransition(OBJ_CONTAINER_BUTTON);
        m_eSelectedMenu = MENU_CONTAINER;
    }
    else if (kText == "Controls")
    {
        SetTransition(OBJ_CONTROLS_BUTTON);
        m_eSelectedMenu = MENU_CONTROLS;
    }
    else if (kText == "Data")
    {
        SetTransition(OBJ_DATA_BUTTON);
        m_eSelectedMenu = MENU_DATA;
    }
    else if (kText == "Keyboard")
    {
        SetTransition(OBJ_TEXT_BUTTON);
        m_eSelectedMenu = MENU_KEYBOARD;
    }
    else if (kText == "Layer")
    {
        SetTransition(OBJ_LAYER_BUTTON);
        m_eSelectedMenu = MENU_LAYER;
    }
    else if (kText == "Scratchpad")
    {
        SetTransition(OBJ_SCRATCHPAD_BUTTON);
        m_eSelectedMenu = MENU_SCRATCHPAD;
    }
    else if (kText == "Settings")
    {
        SetTransition(OBJ_SETTINGS_BUTTON);
        m_eSelectedMenu = MENU_SETTINGS;
    }
}

void CMyGUI::Cleanup()
{
    if (m_pkDialogAdvanced != NULL)
    {
        delete m_pkDialogAdvanced;
        m_pkDialogAdvanced = NULL;
    }

    if (m_pkDialogAnimation != NULL)
    {
        delete m_pkDialogAnimation;
        m_pkDialogAnimation = NULL;
    }

    if (m_pkDialogContainer != NULL)
    {
        delete m_pkDialogContainer;
        m_pkDialogContainer = NULL;
    }

    if (m_pkDialogControls != NULL)
    {
        delete m_pkDialogControls;
        m_pkDialogControls = NULL;
    }

    if (m_pkDialogData != NULL)
    {
        delete m_pkDialogData;
        m_pkDialogData = NULL;
    }

    if (m_pkDialogKeyboard != NULL)
    {
        delete m_pkDialogKeyboard;
        m_pkDialogKeyboard = NULL;
    }

    if (m_pkDialogSettings != NULL)
    {
        delete m_pkDialogSettings;
        m_pkDialogSettings = NULL;
    }

    if (m_pkDialogLayer != NULL)
    {
        delete m_pkDialogLayer;
        m_pkDialogLayer = NULL;
    }

    if (m_pkBoxObserver != NULL)
    {
        delete m_pkBoxObserver;
        m_pkBoxObserver = NULL;
    }
}

void CMyGUI::ShowGlassPane()
{
    if (NULL != m_pkGlassPane)
    {
        m_pkGlassPane->SetInvisible(false);
        GETGUI.DrawOnTop(m_pkGlassPane);
    }
}

void CMyGUI::InitDialog(const ObjectHandle_t& eObjectID)
{
    eC_String kAPI = "";
    m_eSelectedMenu = MENU_UNKNOWN;

    switch (eObjectID)
    {
        case DLG_MAIN:
            kAPI = DIALOG_NAME_MAIN;
            break;

        case DLG_ADVANCED:
            kAPI = DIALOG_NAME_ADVANCED;
            m_eSelectedMenu = MENU_ADVANCED;
            break;

        case DLG_ANIMATION:
            kAPI = DIALOG_NAME_ANIMATION;
            m_eSelectedMenu = MENU_ANIMATION;
            break;

        case DLG_CONTROLS:
            kAPI = DIALOG_NAME_CONTROLS;
            m_eSelectedMenu = MENU_CONTROLS;
            break;

        case DLG_DATA:
            kAPI = DIALOG_NAME_DATA;
            m_eSelectedMenu = MENU_DATA;
            break;

        case DLG_LAYER:
            kAPI = DIALOG_NAME_LAYER;
            m_eSelectedMenu = MENU_LAYER;
            break;

        case DLG_CONTAINER:
            kAPI = DIALOG_NAME_CONTAINER;
            m_eSelectedMenu = MENU_CONTAINER;
            break;

        case DLG_KEYBOARD:
            kAPI = DIALOG_NAME_KEYBOARD;
            m_eSelectedMenu = MENU_KEYBOARD;
            break;

        case DLG_SCRATCHPAD:
            kAPI = DIALOG_NAME_SCRATCHPAD;
            m_eSelectedMenu = MENU_SCRATCHPAD;
            break;

        case DLG_SETTINGS:
            kAPI = DIALOG_NAME_SETTINGS;
            m_eSelectedMenu = MENU_SETTINGS;
            break;

        default:
            kAPI = "";
    }
    DoCallAPI(kAPI, "");
}

void CMyGUI::ShowDialog(const ObjectHandle_t& eDialogID)
{
    ShowGlassPane();
    ChangeBackground(eDialogID);

    if (eDialogID == DLG_MAIN)
    {
        GETCMDHDL.Execute(new CGUIStartAnimationChainCmd(ANIMATION_PULSE));
    }
    else
    {
        GETCMDHDL.Execute(new CGUIStopAnimationChainCmd(ANIMATION_PULSE, false));
    }
}

void CMyGUI::DoCallAPI(const eC_String& kAPI, const eC_String& kParam)
{
    static eC_Bool bToggleSkin = false;
    static eC_Bool bUseNeon = true;
    static eC_Bool bShowFPS = false;
    static eC_Bool bToggleBilinear = false;
    static eC_Bool bToggleInvalidation = false;

    if (kAPI == "EnableRichText")
    {
        /*Toggle between rich-text and normal text on the Text-Dialog*/
        EnableRichText();
    }
    else if (kAPI == "ChangeNeon")
    {
        /*Enable / Disable NEON optimization*/
        bUseNeon = !bUseNeon;
        ToggleOptimizedBlit(bUseNeon);
    }
    else if (kAPI == "ChangeBlitBilinear")
    {
        /*Enable / Disable Bilinear filtering*/
        bToggleBilinear = !bToggleBilinear;
        ToggleFilteredBlit(bToggleBilinear);
    }
    else if (kAPI == "ChangeShowFPS")
    {
        /*Enable / Disable NEON optimization*/
        bShowFPS = !bShowFPS;
        ShowFPS(bShowFPS);
    }
    else if (kAPI == "ChangeShowInvalidation")
    {
        /*Enable / Disable invalidation-lines*/
        bToggleInvalidation = !bToggleInvalidation;

        if (bToggleInvalidation)
            GETGFX.EnableInvalidateAreaLine();
        else
            GETGFX.DisableInvalidateAreaLine();
    }
    else if (kAPI == "ToggleSkin")
    {
        /*Toggle between the dark and light skin on the demo from the settings screen*/
        bToggleSkin = !bToggleSkin;
        ChangeSkin(bToggleSkin);

        // Since the current active dialog is "Settings", the foreground color of its Geometry object is
        // changed immediately. The foreground color for other dialogs will be changed, when transition
        // occurs and they are loaded.
        ChangeBackground(DLG_SETTINGS);
    }
    else if (kAPI == "StartAnimation")
    {
        /*Calling the HandleCallAPI from the DemoAnimation-Class to set the index of the animation that needs to be called*/
        if (NULL != m_pkDialogAnimation)
        {
            m_pkDialogAnimation->HandleCallAPI(kAPI, kParam);
        }
    }
    else if (kAPI == "Video")
    {
        /*Calling the HandleCallAPI from the DemoAnimation-Class to set the index of the animation that needs to be called*/
        if (NULL != m_pkDialogAnimation)
        {
            m_pkDialogAnimation->HandleCallAPI(kAPI, kParam);
        }
    }
    else if (kAPI == "SetArabic")
    {
        m_eActiveLanguage = DemoSettings::ARABIC;
        GETGUI.InvalidateArea();
    }
    else if (kAPI == "SetGerman")
    {
        m_eActiveLanguage = DemoSettings::GERMAN;
        GETGUI.InvalidateArea();
    }
    else if (kAPI == "SetEnglish")
    {
        m_eActiveLanguage = DemoSettings::ENGLISH;
        GETGUI.InvalidateArea();
    }
    else if (kAPI == "SetRussian")
    {
        m_eActiveLanguage = DemoSettings::RUSSIAN;
        GETGUI.InvalidateArea();
    }
    else if (
        (kAPI == "ToggleKnob") ||
        (kAPI == "HighWheel") ||
        (kAPI == "MiddleWheel") ||
        (kAPI == "LowWheel")
        )
    {
        if (NULL != m_pkDialogAdvanced)
            m_pkDialogAdvanced->HandleCallAPI(kAPI, kParam);
    }
    else if (
        (kAPI == "DecSegment") ||
        (kAPI == "IncSegment")
        )
    {
        if (NULL != m_pkDialogControls)
            m_pkDialogControls->HandleCallAPI(kAPI, kParam);
    }
    else if (kAPI == DIALOG_NAME_MAIN)
    {
        ShowDialog(DLG_MAIN);
    }
    else if (kAPI == DIALOG_NAME_ADVANCED)
    {
        if (NULL == m_pkDialogAdvanced)
            m_pkDialogAdvanced = new DemoAdvanced();

        m_uiCurrentTime += ((GETTIMER.GetTime() - m_uiCurrentIdleTime) / 1000);
        m_pkDialogAdvanced->Init(m_uiCurrentTime);
        m_pkDialogAdvanced->SetLanguage(m_eActiveLanguage);
        m_pkDialogAdvanced->SetEasing(m_eGaugeEasingType);

        ShowDialog(DLG_ADVANCED);
    }
    else if (kAPI == DIALOG_NAME_ANIMATION)
    {
        if (NULL == m_pkDialogAnimation)
            m_pkDialogAnimation = new DemoAnimation();

        m_pkDialogAnimation->Init();

        ShowDialog(DLG_ANIMATION);
    }
    else if (kAPI == DIALOG_NAME_CONTROLS)
    {
        if (NULL == m_pkDialogControls)
            m_pkDialogControls = new DemoControls();

        m_pkDialogControls->Init();
        m_pkDialogControls->SetColor(m_uiBackgroundColor);

        ShowDialog(DLG_CONTROLS);
    }
    else if (kAPI == DIALOG_NAME_CONTAINER)
    {
        if (NULL == m_pkDialogContainer)
            m_pkDialogContainer = new DemoContainer();

        m_pkDialogContainer->Init();

        ShowDialog(DLG_CONTAINER);
    }
    else if (kAPI == DIALOG_NAME_DATA)
    {
        if (NULL == m_pkDialogData)
            m_pkDialogData = new DemoData();

        m_pkDialogData->Init();

        ShowDialog(DLG_DATA);
    }
    else if (kAPI == DIALOG_NAME_KEYBOARD)
    {
        if (NULL == m_pkDialogKeyboard)
            m_pkDialogKeyboard = new DemoKeyboard();

        m_pkDialogKeyboard->Init();
        m_pkDialogKeyboard->LoadLayout(m_eActiveLanguage);

        ShowDialog(DLG_KEYBOARD);
    }
    else if (kAPI == DIALOG_NAME_LAYER)
    {
        if (NULL == m_pkDialogLayer)
            m_pkDialogLayer = new DemoLayer();

        m_pkDialogLayer->Init();
        ShowDialog(DLG_LAYER);
    }
    else if (kAPI == DIALOG_NAME_SCRATCHPAD)
    {
        ShowDialog(DLG_SCRATCHPAD);
    }
    else if (kAPI == DIALOG_NAME_SETTINGS)
    {
        /*API Call to create an instance of the DemoSettings. It is needed, because the object requires Controlls that are not created*/
        if (NULL == m_pkDialogSettings)
            m_pkDialogSettings = new DemoSettings();

        // first set settings
        m_pkDialogSettings->SetEasing(m_eGaugeEasingType);
        m_pkDialogSettings->SetBackgroundImage(m_eBackgroundImage);
        m_pkDialogSettings->SetBackgroundColor(m_uiBackgroundColor);
        m_pkDialogSettings->SetTransition(m_eTransitionType);
        // init uses setting to select combobox-entries
        m_pkDialogSettings->Init();

        ShowDialog(DLG_SETTINGS);
    }
    else if (kAPI.Find("MessageBox") != eC_String::npos)
    {
        GETPROPHDL.SetGlobalColorProperty(GUI_PROP_DEFAULT_COLOR, 0xFF989898);
        GETPROPHDL.SetGlobalColorProperty(GUI_PROP_DEFAULT_HIGHLIGHT_COLOR, 0xFFA5A5A5);
        GETPROPHDL.SetGlobalColorProperty(GUI_PROP_DEFAULT_PRESSED_COLOR, 0xFF656565);
        CGUICompositeObject* pkParent = dynamic_cast<CGUICompositeObject*>(GetChild(0));

        if (NULL != pkParent)
        {
            eC_Value vMessageBoxWidth = eC_FromInt(300);
            eC_Value vMessageBoxHeight = eC_FromInt(250);
            if (kAPI == "MessageBoxSmall")
            {
                vMessageBoxWidth = eC_FromInt(200);
                vMessageBoxHeight = eC_FromInt(140);
            }

            if (vMessageBoxWidth > GetWidth())
                vMessageBoxWidth = GetWidth() - eC_FromInt(20);
            if (vMessageBoxHeight > GetHeight())
                vMessageBoxHeight = GetHeight() - eC_FromInt(20);

            eC_Value vMessageBoxXPos = eC_Div((pkParent->GetWidth() - vMessageBoxWidth), eC_FromInt(2));
            eC_Value vMessageBoxYPos = eC_Div((pkParent->GetHeight() - vMessageBoxHeight), eC_FromInt(2));
            CGUIBaseMessageBox* pkMessageBox = new CGUIBaseMessageBox(pkParent, vMessageBoxXPos, vMessageBoxYPos, vMessageBoxWidth, vMessageBoxHeight, "", true);
            if (NULL != pkMessageBox)
            {
                pkMessageBox->SetBackgroundColor(0xFFEFEFEF);
                pkMessageBox->SetTextFont(HEADER_FNT);
                pkMessageBox->SetText(kParam);

                pkMessageBox->SetButtonFont(MENU_FONT);
            }
        }
    }
    else if (kAPI == "Clean")
    {
        // remove box-observer when dialog is removed
        if (NULL != m_pkBoxObserver)
        {
            delete m_pkBoxObserver;
            m_pkBoxObserver = NULL;
        }

        // save settings from dialog and navigate to correct menu-item in main-menu
        if (MENU_UNKNOWN != m_eSelectedMenu)
        {
            if (m_eSelectedMenu == MENU_ADVANCED)
            {
                if (m_pkDialogAdvanced)
                {
                    // get elapsed time and stamp internal timer
                    m_uiCurrentTime = m_pkDialogAdvanced->GetTime();
                    m_uiCurrentIdleTime = GETTIMER.GetTime();

                    delete m_pkDialogAdvanced;
                    m_pkDialogAdvanced = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_ANIMATION)
            {
                if (NULL != m_pkDialogAnimation)
                {
                    delete m_pkDialogAnimation;
                    m_pkDialogAnimation = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_CONTROLS)
            {
                if (m_pkDialogControls)
                {
                    m_uiBackgroundColor = m_pkDialogControls->GetColor();

                    delete m_pkDialogControls;
                    m_pkDialogControls = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_CONTAINER)
            {
                if (NULL != m_pkDialogContainer)
                {
                    delete m_pkDialogContainer;
                    m_pkDialogContainer = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_DATA)
            {
                if (NULL != m_pkDialogData)
                {
                    delete m_pkDialogData;
                    m_pkDialogData = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_KEYBOARD)
            {
                if (NULL != m_pkDialogKeyboard)
                {
                    delete m_pkDialogKeyboard;
                    m_pkDialogKeyboard = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_LAYER)
            {
                if (NULL != m_pkDialogLayer)
                {
                    delete m_pkDialogLayer;
                    m_pkDialogLayer = NULL;
                }
            }
            else if (m_eSelectedMenu == MENU_SCRATCHPAD)
            {
            }
            else if (m_eSelectedMenu == MENU_SETTINGS)
            {
                if (NULL != m_pkDialogSettings)
                {
                    // save settings
                    m_pkDialogSettings->HandleCallAPI(kAPI, kParam);

                    m_eTransitionType = m_pkDialogSettings->GetTransition();
                    m_eBackgroundImage = m_pkDialogSettings->GetBackgroundImage();
                    m_eGaugeEasingType = m_pkDialogSettings->GetEasing();
                    //m_uiBackgroundColor = m_pkDialogSettings->GetBackgroundColor();
                    m_eImageMode = m_pkDialogSettings->GetImageMode();

                    delete m_pkDialogSettings;
                    m_pkDialogSettings = NULL;
                }
            }

            ShowDialog(DLG_MAIN);
        }
    }
    else if (kAPI == "SetTransition")
    {
        SetTransition(kParam);
    }
    else if (kAPI == "InfoText")
    {
        AnimateInfoTxt();
    }
    else if (kAPI == "StartPlayback")
    {
        static_cast<CGUIPlaybackInput&>(GETINPUTMEDIA).StartPlayback();
    }
    else if (kAPI == "Rotate90")
    {
        Rotate(90);
    }
    else if (kAPI == "Rotate270")
    {
        Rotate(270);
    }
    else if (kAPI == "FlipH")
    {
        Flip(false);
    }
    else if (kAPI == "FlipV")
    {
        Flip(true);
    }
    else if (
        (kAPI == "ZoomIn") ||
        (kAPI == "ZoomOut") ||
        (kAPI == "ChartType") ||
        (kAPI == "SelectData") ||
        (kAPI == "ZoomInGraph") ||
        (kAPI == "ZoomOutGraph") ||
        (kAPI == "ZoomInPlot") ||
        (kAPI == "ZoomOutPlot") ||
        (kAPI == "AutoRefresh")
        )
    {
        if (NULL != m_pkDialogData)
        {
            m_pkDialogData->HandleCallAPI(kAPI, kParam);
        }
    }
    else if (kAPI == "LayerContent")
    {
        if (NULL != m_pkDialogLayer)
        {
            m_pkDialogLayer->HandleCallAPI(kAPI, kParam);
        }
    }
    else
    {
        /* pass everything else to the container-dialog */
        if (NULL != m_pkDialogContainer)
        {
            m_pkDialogContainer->HandleCallAPI(kAPI, kParam);
        }
    }
}

void CMyGUI::EnableRichText()
{
    CGUIBaseTextField* pkNormalText = static_cast<CGUIBaseTextField*>(GETGUI.GetObjectByID(NORMAL_TEXT_FIELD));
    CGUIBaseTextField* pkRichText = static_cast<CGUIBaseTextField*>(GETGUI.GetObjectByID(RICH_TEXT_FIELD));
    if (pkNormalText != NULL && pkRichText != NULL)
    {
        pkNormalText->SetInvisible(!(pkNormalText->IsInvisible()));
        pkRichText->SetInvisible(!(pkRichText->IsInvisible()));
    }
}

void CMyGUI::ToggleOptimizedBlit(const eC_Bool& bToggle)
{
    GETGFX.SetOptimizedBlit(bToggle);
    GETGUI.InvalidateArea();
}

void CMyGUI::ShowFPS(const eC_Bool& bShowFPS)
{
    GETFPS.SetInvisible(!bShowFPS);
}

void CMyGUI::ToggleFilteredBlit(const eC_Bool& bToggle)
{
    GETGFX.SetFilteredBlit(bToggle);
    GETGUI.InvalidateArea();
}

void CMyGUI::ChangeSkin(const eC_Bool& bToggle)
{
    if (true == bToggle)
    {
        m_eImageMode = DemoSettings::IM_DARK_MODE;

        if (GETRESMANAGER.GetImagesFilename() == "Light")
            GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_IMAGE, "Dark"));
        else
            GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_IMAGE, "DarkSimple"));

        GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_PROPERTY, "Dark"));
    }
    else
    {
        m_eImageMode = DemoSettings::IM_LIGHT_MODE;

        if (GETRESMANAGER.GetImagesFilename() == "Dark")
            GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_IMAGE, "Light"));
        else
            GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_IMAGE, "LightSimple"));

        GETCMDHDL.Execute(new CGUISwitchResourceSetsCmd(RT_PROPERTY, "Light"));
    }

    if (NULL != m_pkDialogSettings)
    {
        m_eBackgroundImage = m_pkDialogSettings->GetBackgroundImage();
        //m_uiBackgroundColor = m_pkDialogSettings->GetBackgroundColor();
    }

    GETGUI.InvalidateArea();
}

void CMyGUI::ChangeBackground(const ObjectHandle_t& eObjectID)
{
    CGUICompositeObject *pkDialogCompObj = this;
    if (NO_HANDLE != eObjectID)
    {
        // Get the dialog of eObjectID, which is a composite object
        pkDialogCompObj =  dynamic_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(eObjectID));
        if (NULL != pkDialogCompObj)
        {
            CGUIGeometryObject* pkBackgroundRect = dynamic_cast<CGUIGeometryObject*>(pkDialogCompObj->GetObjectByID(OBJ_BACKGROUND_GEO));
            CGUIImage* pkImage = dynamic_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(OBJ_BACKGROUND_IMAGE));

            // depending on background-image
            if (
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_NATIVE) ||
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_RLE) ||
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_RAW)
                )
            {
                if (NULL != pkImage)
                {
                    pkImage->SetImage(m_eBackgroundImage, false);
                    //pkImage->SetStretchBlit(false);
                    pkImage->SetInvisible(false);
                    pkImage->InvalidateArea();
                }

                if (NULL != pkBackgroundRect)
                    pkBackgroundRect->SetInvisible(true);
            }
            else
            {
                if (NULL != pkImage)
                    pkImage->SetInvisible(true);

                if (NULL != pkBackgroundRect)
                {
                    pkBackgroundRect->SetColor(m_uiBackgroundColor);
                    pkBackgroundRect->SetInvisible(false);
                    pkBackgroundRect->InvalidateArea();
                }
            }
        }
    }
}

void CMyGUI::AnimateInfoTxt()
{
    CGUIBaseTextField* pkTextField = static_cast<CGUITextField*>(GETGUI.GetObjectByID(INFO_TEXT));
    CGUIGeometryObject* pkBackground = static_cast<CGUIGeometryObject*>(GETGUI.GetObjectByID(TEXT_BACKDROP));
    CGUICompositeObject* pkContainer = static_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(INFO_CONTAINER));

    // since comboboxes get drawn on top of all other siblings, when they are opened, move container to top
    if ((NULL != pkContainer) && (NULL != pkContainer->GetParent()))
        pkContainer->GetParent()->DrawOnTop(pkContainer);

    if (m_pkBoxObserver != NULL)
    {
        delete m_pkBoxObserver;
        m_pkBoxObserver = NULL;
    }

    if (NULL != pkTextField)
    {
        eC_Value vTargetXPos = pkTextField->GetRelXPos();
        eC_Value vTargetYPos = pkTextField->GetRelYPos();
        eC_Value vTargetWidth = pkTextField->GetWidth();
        eC_Value vTargetHeight = pkTextField->GetHeight();

        if (pkTextField->IsInvisible())
        {
            // hide layers to have info-text appear on top
            if (m_eSelectedMenu == MENU_LAYER)
            {
                CGUIObject* pkObject = GETGUI.GetObjectByID(OBJ_LAYER1);
                if (NULL != pkObject)
                    pkObject->SetInvisible(true);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER2);
                if (NULL != pkObject)
                    pkObject->SetInvisible(true);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER3);
                if (NULL != pkObject)
                    pkObject->SetInvisible(true);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER4);
                if (NULL != pkObject)
                    pkObject->SetInvisible(true);
            }

            if (NULL != pkBackground)
                pkBackground->SetInvisible(false);

            pkTextField->SetInvisible(false);
            pkTextField->SetAlpha(0);
            CGUIAnimationSize* pkSizeAnimation = new CGUIAnimationSize(pkBackground, CGUIEasing::EASE_IN_CUBIC, CGUIEasing::EASE_OUT_CUBIC, 0, 0, vTargetWidth, vTargetHeight, false, 250, 20);
            CGUIAnimationMove* pkMoveAnimation = new CGUIAnimationMove(pkBackground, CGUIEasing::EASE_IN_CUBIC, CGUIEasing::EASE_OUT_CUBIC, vTargetWidth, vTargetHeight, vTargetXPos, vTargetYPos, 250, false, 20);

            if (m_pkBoxObserver == NULL)
            {
                m_pkBoxObserver = new BoxObserver(true);
            }
            pkSizeAnimation->SetAnimationObserver(m_pkBoxObserver);

            pkMoveAnimation->SetDeletedAfterFinish(true);
            pkMoveAnimation->StartAnimation();

            pkSizeAnimation->SetDeletedAfterFinish(true);
            pkSizeAnimation->StartAnimation();
        }
        else
        {
            // hide layers to have info-text appear on top
            if (m_eSelectedMenu == MENU_LAYER)
            {
                CGUIObject* pkObject = GETGUI.GetObjectByID(OBJ_LAYER1);
                if (NULL != pkObject)
                    pkObject->SetInvisible(false);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER2);
                if (NULL != pkObject)
                    pkObject->SetInvisible(false);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER3);
                if (NULL != pkObject)
                    pkObject->SetInvisible(false);

                pkObject = GETGUI.GetObjectByID(OBJ_LAYER4);
                if (NULL != pkObject)
                    pkObject->SetInvisible(false);
            }

            pkTextField->SetInvisible(true);
            pkTextField->SetAlpha(255);
            CGUIAnimationSize* pkSizeAnimation = new CGUIAnimationSize(pkBackground, CGUIEasing::EASE_IN_CUBIC, CGUIEasing::EASE_OUT_CUBIC, vTargetWidth, vTargetHeight, 0, 0, false, 250, 20);
            CGUIAnimationMove* pkMoveAnimation = new CGUIAnimationMove(pkBackground, CGUIEasing::EASE_IN_CUBIC, CGUIEasing::EASE_OUT_CUBIC, vTargetXPos, vTargetYPos, vTargetWidth, vTargetHeight, 250, false, 20);

            if (m_pkBoxObserver == NULL)
            {
                m_pkBoxObserver = new BoxObserver(false);
            }
            pkSizeAnimation->SetAnimationObserver(m_pkBoxObserver);

            pkMoveAnimation->SetDeletedAfterFinish(true);
            pkMoveAnimation->StartAnimation();

            pkSizeAnimation->SetDeletedAfterFinish(true);
            pkSizeAnimation->StartAnimation();
        }
    }
}

// set dialog-transition within command to appropriate type
void CMyGUI::SetTransition(const ObjectHandle_t& button)
{
    CGUIButton* pkBackButton = dynamic_cast<CGUIButton*>(GETGUI.GetObjectByID(button));
    if (NULL != pkBackButton)
    {
        CGUICommandPtr CmdPtr = pkBackButton->GetCommand();
        if (CmdPtr)
        {
            CGUICommand* pkCommand = CmdPtr->GetAdditionalCmd(0).RawPtr();
            CGUITransitionCmd* pkTransitionCmd = dynamic_cast<CGUITransitionCmd*>(pkCommand);
            if (NULL != pkTransitionCmd)
            {
                pkTransitionCmd->SetTransitionType(m_eTransitionType);
            }
        }
    }
}

void CMyGUI::NotifyOfDestruction(const CGUIObject* pDestructedObject)
{
    if (NULL != m_pkGlassPane)
    {
        m_pkGlassPane->SetInvisible(true);
    }
}
