#include "DemoSettings.h"

#include "GUI.h"
#include "GUIGeometryObject.h"
#include "GUIImage.h"
#include "GUIListItem.h"
#include "GUIScrollBar.h"
#include "GUICheckBox.h"
#include "GUIObserver.h"

#include "GfxWrap.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

void DemoSettings::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_SETTINGS));

    m_kEasings[0] = CGUIEasing::EASE_OUT_EXPO;
    m_kEasings[1] = CGUIEasing::EASE_IN_QUAD;
    m_kEasings[2] = CGUIEasing::EASE_IN_OUT_SINE;
    m_kEasings[3] = CGUIEasing::EASE_OUT_CIRC;

    m_pkCombo1 = auto_cast<CGUIComboBox*>(m_pkDialog->GetObjectByID(EASING_TYPES));

    /*Set the header combobox*/
    if (NULL != m_pkCombo1)
    {
        m_pkCombo1->SetSelection(GetEasingIndex());
        m_pkCombo1->SetHeaderEditable(false);
    }

    m_kBackground[0] = IMG_BACKGROUNDIMAGE;
    m_kBackground[1] = IMG_GUILIANI_DEMO_BACKGROUND_NATIVE;
    m_kBackground[2] = IMG_GUILIANI_DEMO_BACKGROUND_RLE;
    m_kBackground[3] = IMG_GUILIANI_DEMO_BACKGROUND_RAW;

    //Another combobox with 4 values for the different backgrounds
    m_pkCombo2 = auto_cast<CGUIComboBox*>(m_pkDialog->GetObjectByID(BG_TYPES));

    /*Set the header combobox*/
    if (NULL != m_pkCombo2)
    {
        m_pkCombo2->SetSelection(GetBackgroundIndex());
        m_pkCombo2->SetHeaderEditable(false);
        m_pkCombo2->AddSelectionObserver(this);
    }

    m_kTransitions[0] = CGUITransitionCmd::PUSH_FROM_LEFT;
    m_kTransitions[1] = CGUITransitionCmd::PUSH_FROM_RIGHT;
    m_kTransitions[2] = CGUITransitionCmd::PUSH_FROM_TOP;
    m_kTransitions[3] = CGUITransitionCmd::PUSH_FROM_BOTTOM;
    m_kTransitions[4] = CGUITransitionCmd::DISSOLVE;

    //Another combobox with 5 values for the different transition types, pass the value to the main class
    m_pkCombo3 = auto_cast<CGUIComboBox*>(m_pkDialog->GetObjectByID(TRANSITION_TYPE));

    /*Set the header combobox*/
    if (NULL != m_pkCombo3)
    {
        m_pkCombo3->SetSelection(GetTransitionIndex());
        m_pkCombo3->SetHeaderEditable(false);
    }

    CGUITextField* pkVersion = auto_cast<CGUITextField*>(m_pkDialog->GetObjectByID(TXT_VERSION));
    if (NULL != pkVersion)
    {
        pkVersion->GetLabel()->SetTextString("Guiliani V" + CGUI::GetVersionString() + " GFX: " + GETGFX.GetWrapperName() + "\nPlatform: " + CGUI::GetPlatformString());
    }

    CGUIImage* pkPlatformImage = dynamic_cast<CGUIImage*>(m_pkDialog->GetObjectByID(IMG_PLATFORM));
#if defined(eC_TARGET_ENV_RZA1H) || defined(eC_TARGET_ENV_RZA2M)
    pkPlatformImage->SetImage(IMG_RZ_LOGO);
#elif defined(eC_TARGET_ENV_RA6M3)
    pkPlatformImage->SetImage(IMG_RA_LOGO);
#else
    pkPlatformImage->SetImage(DUMMY_IMAGE);
#endif
}

DemoSettings::~DemoSettings()
{
    DeInit();
}

void DemoSettings::DeInit()
{
}

void DemoSettings::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    // selection changed
    if (NULL != m_pkCombo2)
    {
        m_eBackgroundImage = m_kBackground[m_pkCombo2->GetSelection()];
        ChangeBackground(DLG_SETTINGS);
    }
}

/*Handling for leaving the settings dialog, gets the string and stores it*/
void DemoSettings::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "Clean")
    {
        if (NULL != m_pkCombo1)
        {
            m_eGaugeEasing = m_kEasings[m_pkCombo1->GetSelection()];
        }

        if (NULL != m_pkCombo2)
        {
            m_eBackgroundImage = m_kBackground[m_pkCombo2->GetSelection()];
        }

        if (NULL != m_pkCombo3)
        {
            //Grab the selected value of the transition type
            m_eTransitionType = m_kTransitions[m_pkCombo3->GetSelection()];
        }
    }
}

void DemoSettings::ChangeBackground(const ObjectHandle_t& eObjectID)
{
    if (NO_HANDLE != eObjectID)
    {
        // Get the dialog of eObjectID, which is a composite object
        CGUICompositeObject *pkDialogCompObj = auto_cast<CGUICompositeObject*>(m_pkDialog->GetObjectByID(eObjectID));
        if (NULL != pkDialogCompObj)
        {
            CGUIGeometryObject* pkBackgroundRect = auto_cast<CGUIGeometryObject*>(pkDialogCompObj->GetObjectByID(OBJ_BACKGROUND_GEO));
            CGUIImage* pkImage = auto_cast<CGUIImage*>(pkDialogCompObj->GetObjectByID(OBJ_BACKGROUND_IMAGE));

            // depending on background-image
            if (
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_NATIVE) ||
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_RLE) ||
                (m_eBackgroundImage == IMG_GUILIANI_DEMO_BACKGROUND_RAW)
                )
            {
                if (NULL != pkImage)
                {
                    pkImage->SetImage(m_eBackgroundImage);
                    pkImage->SetInvisible(false);
                    pkImage->InvalidateArea();
                }

                if (NULL != pkBackgroundRect)
                    pkBackgroundRect->SetInvisible(true);
            }
            else
            {
                if (NULL != pkImage)
                {
                    pkImage->SetImage(DUMMY_IMAGE);
                    pkImage->SetInvisible(true);
                }

                if (NULL != pkBackgroundRect)
                {
                    pkBackgroundRect->SetColor(m_uiBackgroundColor);
                    pkBackgroundRect->SetInvisible(false);
                    pkBackgroundRect->InvalidateArea();
                }
            }
        }
    }
}

eC_Bool DemoSettings::IsCheckBoxSelected(const ObjectHandle_t& eObjectID) const
{
    eC_Bool bRet = false;
    CGUICheckBox* pkCheckBox = auto_cast<CGUICheckBox*>(m_pkDialog->GetObjectByID(eObjectID));

    if (NULL != pkCheckBox)
    {
        bRet = pkCheckBox->IsSelected();
    }

    return bRet;
}

void DemoSettings::SelectCheckBox(const ObjectHandle_t& eObjectID, const eC_Bool& bSelected, const eC_Bool& bVisible) const
{
    CGUICheckBox* pkCheckBox = auto_cast<CGUICheckBox*>(m_pkDialog->GetObjectByID(eObjectID));

    if (NULL != pkCheckBox)
    {
       pkCheckBox->SetSelected(bSelected);
       pkCheckBox->SetInvisible(!bVisible);
    }
}

DemoSettings::ImageMode_t DemoSettings::GetImageMode()
{
    return m_eImageMode;
}

CGUIEasing::EasingType_t DemoSettings::GetEasing() const
{
    return m_eGaugeEasing;
}

ImageResource_t DemoSettings::GetBackgroundImage() const
{
    return m_eBackgroundImage;
}

CGUITransitionCmd::TransitionType_t DemoSettings::GetTransition() const
{
    return m_eTransitionType;
}

void DemoSettings::SetEasing(CGUIEasing::EasingType_t eEasing)
{
    m_eGaugeEasing = eEasing;
}

void DemoSettings::SetBackgroundImage(ImageResource_t eID)
{
    m_eBackgroundImage = eID;
}

void DemoSettings::SetBackgroundColor(const eC_UInt& uiBackgroundColor)
{
    m_uiBackgroundColor = uiBackgroundColor;
}

void DemoSettings::SetTransition(CGUITransitionCmd::TransitionType_t eTransition)
{
    m_eTransitionType = eTransition;
}

eC_Int DemoSettings::GetEasingIndex() const
{
    for (eC_Int idx = 0; idx < MAX_EASINGS; ++idx)
    {
        if (m_eGaugeEasing == m_kEasings[idx])
        {
            return idx;
        }
    }
    return 0;
}

eC_Int DemoSettings::GetBackgroundIndex() const
{
    for (eC_Int idx = 0; idx < MAX_BACKGROUNDS; ++idx)
    {
        if (m_eBackgroundImage == m_kBackground[idx])
        {
            return idx;
        }
    }
    return 0;
}

eC_Int DemoSettings::GetTransitionIndex() const
{
    for (eC_Int idx = 0; idx < MAX_TRANSITIONS; ++idx)
    {
        if (m_eTransitionType == m_kTransitions[idx])
        {
            return idx;
        }
    }
    return 0;
}
