#include "DemoLayer.h"

#include "GUI.h"
#include "GUIObserver.h"
#include "GUIImage.h"
#include "GUITextField.h"

#include "DCWrap.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

DemoLayer::DemoLayer() :
    m_pkAlphaSlider(NULL)
{
    for (eC_UInt index = 0; index < MAX_LAYER_ID; ++index)
    {
        m_kLayerData[index].ID = 0;
        m_kLayerData[index].Running = false;
        m_kLayerData[index].Width = 0;
        m_kLayerData[index].Height = 0;
        m_kLayerData[index].BPP = 0;
    }
}

DemoLayer::~DemoLayer()
{
    DeInit();
}

void DemoLayer::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_LAYER));

    m_pkAlphaSlider = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_HORIZONTAL));
    if (NULL != m_pkAlphaSlider)
        m_pkAlphaSlider->AddValueObserver(this);

    CGUICompositeObject* pkLayerContainer = auto_cast<CGUICompositeObject*>(m_pkDialog->GetObjectByID(OBJ_PAGECONTAINER));
    CGUITextField* pkNotSupported = auto_cast<CGUITextField*>(m_pkDialog->GetObjectByID(RICH_TEXT_FIELD));

#if defined GFX_USE_DCWRAP
    if (NULL != pkLayerContainer)
        pkLayerContainer->SetInvisible(GETDC.IsNull());

    if (NULL != pkNotSupported)
        pkNotSupported->SetInvisible(!GETDC.IsNull());

    for (eC_UInt uiLayerId = 0; uiLayerId < MAX_LAYER_ID; ++uiLayerId)
    {
        LayerConfiguration_t kLayerConfig;
        if (
            (GETDC.GetLayerConfigForID(uiLayerId, kLayerConfig)) &&
            (!kLayerConfig.m_bMainLayer)
            )
        {
            m_kLayerData[uiLayerId].Active = true;
            m_kLayerData[uiLayerId].ID = kLayerConfig.m_uiLayerID;
            GETDC.GetLayerBufferSize(
                kLayerConfig.m_uiLayerID,
                m_kLayerData[uiLayerId].Width,
                m_kLayerData[uiLayerId].Height,
                m_kLayerData[uiLayerId].BPP);
            m_kLayerData[uiLayerId].Running = false;
        }
        else
        {
            m_kLayerData[uiLayerId].Active = false;
        }
    }

    GETTIMER.AddAnimationCallback(100, this);
#else
    if (NULL != pkLayerContainer)
        pkLayerContainer->SetInvisible(true);

    if (NULL != pkNotSupported)
        pkNotSupported->SetInvisible(false);
#endif
}

void DemoLayer::DeInit()
{
    if (NULL != m_pkAlphaSlider)
        m_pkAlphaSlider->RemoveValueObserver(this);
    m_pkAlphaSlider = NULL;

    GETTIMER.RemoveAnimationCallback(this);
}

void DemoLayer::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (NULL != pkUpdatedObject)
    {
        if (pkUpdatedObject->GetID() == SLIDER_HORIZONTAL)
        {
#if defined GFX_USE_DCWRAP
            for (eC_UInt uiLayerIndex = 0; uiLayerIndex < MAX_LAYER_ID; ++uiLayerIndex)
            {
                if (!m_kLayerData[uiLayerIndex].Active)
                    continue;

                eC_UInt uiLayerID = m_kLayerData[uiLayerIndex].ID;
                GETDC.SetLayerAlpha(uiLayerID, (eC_UByte)m_pkAlphaSlider->GetRange().GetValue());
                GETDC.InvalidateLayer(uiLayerID);
            }
#endif
        }
    }
}

void DemoLayer::DoAnimate(const eC_Value &vTimes)
{
#if defined GFX_USE_DCWRAP
    static eC_UByte ubValue = 0;
    for (eC_UInt uiLayerIndex = 0; uiLayerIndex < MAX_LAYER_ID; ++uiLayerIndex)
    {
        eC_UInt uiLayerID = m_kLayerData[uiLayerIndex].ID;
        if (m_kLayerData[uiLayerIndex].Running)
        {
            // might change if more than 1 buffer
            void* pkLayer = GETDC.GetRenderBuffer(uiLayerID);
            if (NULL != pkLayer)
                memset(
                    pkLayer,
                    ubValue += 5,
                    m_kLayerData[uiLayerIndex].Width * m_kLayerData[uiLayerIndex].Height * m_kLayerData[uiLayerIndex].BPP);

            GETDC.InvalidateLayer(uiLayerID);
        }
    }
#endif
}

void DemoLayer::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "LayerContent")
    {
        eC_Int iParamIndex;
        if (kParam.ToInt(iParamIndex))
        {
            if ((iParamIndex > 0) && (iParamIndex < MAX_LAYER_ID))
            {
                if (m_kLayerData[iParamIndex].Active)
                    m_kLayerData[iParamIndex].Running = !m_kLayerData[iParamIndex].Running;
            }
        }
    }
}
