#include "DemoKeyboard.h"

#include "GUI.h"
#include "GUIBaseCheckBox.h"
#include "GUIEdit.h"
#include "GUIEditableText.h"
#include "GUIObserver.h"
#include "GUIKeyboard.h"
#include "GUIImage.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

ObsvShowPassword::ObsvShowPassword(CGUIEdit* pkPasswordField, CGUIBaseCheckBox* pkCheckbox) :
    m_pkCheckbox(pkCheckbox),
    m_pkPasswordField(pkPasswordField)
{
    if (m_pkCheckbox != NULL)
    {
        m_pkCheckbox->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("EDIT_PASSWORD: InputField is missing\n"));
    }
}

void ObsvShowPassword::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if ((NULL != m_pkPasswordField) && (NULL != m_pkCheckbox))
    {
        eC_Bool bSelected = m_pkCheckbox->IsSelected();
        m_pkPasswordField->GetLabel()->SetPasswordMode(!bSelected);

        m_pkPasswordField->InvalidateArea();
    }
}

ObsvTextWidth::ObsvTextWidth(CGUITextField* pkField, CGUITextField* pkFieldRich, CGUIBaseSlider* pkSlider) :
    m_pkTargetObject(pkField),
    m_pkTargetObjectRich(pkFieldRich)
{
    if (pkSlider != NULL)
    {
        pkSlider->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("TILT_OBSERVER: Slider is missing\n"));
    }
}

void ObsvTextWidth::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (m_pkTargetObject != NULL && m_pkTargetObjectRich != NULL)
    {
        /*Get the value of the left slider and set it for the tilt-angle*/
        eC_Value newVal = kObservedValue.ToValue();

        m_pkTargetObject->SetWidth(newVal);
        m_pkTargetObjectRich->SetWidth(newVal);
        m_pkTargetObject->InvalidateArea();
        m_pkTargetObjectRich->InvalidateArea();
    }
}

DemoKeyboard::DemoKeyboard() :
    m_pkShowPassword(NULL),
    m_pkWidthSlider(NULL)
{
}

DemoKeyboard::~DemoKeyboard()
{
    DeInit();
}

void DemoKeyboard::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_KEYBOARD));

    GUILOG(GUI_TRACE_DEBUG, eC_String("DEMO_KEYBOARD: get Password-field\n"));
    CGUIEdit* pkPasswordField = auto_cast<CGUIEdit*>(m_pkDialog->GetObjectByID(EDIT_PASSWORD));
    CGUIBaseCheckBox* pkCheckbox = auto_cast<CGUIBaseCheckBox*>(m_pkDialog->GetObjectByID(CHK_SHOWPASS));

    m_pkShowPassword = new ObsvShowPassword(pkPasswordField, pkCheckbox);
    m_pkKeyboard = auto_cast<CGUIKeyboard*>(m_pkDialog->GetObjectByID(OBJ_KEYBOARD));

    GUILOG(GUI_TRACE_DEBUG, eC_String("DEMO_TEXT:Fetching the normal textfield Object\n"));
    CGUITextField* pkTextField = auto_cast<CGUITextField*>(m_pkDialog->GetObjectByID(NORMAL_TEXT_FIELD));
    GUILOG(GUI_TRACE_DEBUG, eC_String("DEMO_TEXT:Fetching the rich textfield Object\n"));
    CGUITextField* pkTextFieldRich = auto_cast<CGUITextField*>(m_pkDialog->GetObjectByID(RICH_TEXT_FIELD));
    GUILOG(GUI_TRACE_DEBUG, eC_String("DEMO_TEXT:Fetching the width slider Object\n"));
    CGUIBaseSlider* pkWidthSlider = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(TEXT_WIDTH));

    m_pkWidthSlider = new ObsvTextWidth(pkTextField, pkTextFieldRich, pkWidthSlider);
}

void DemoKeyboard::DeInit()
{
    delete m_pkShowPassword;
    m_pkShowPassword = NULL;

    delete m_pkWidthSlider;
    m_pkWidthSlider = NULL;
}

void DemoKeyboard::LoadLayout(eC_Int iActiveLanguage)
{
    GeneralResource_t eID = KBD_LAYOUT_ENGLISH;
    if (iActiveLanguage == 1)
        eID = KBD_LAYOUT_GERMAN;
    if (iActiveLanguage == 2)
        eID = KBD_LAYOUT_RUSSIAN;
    if (iActiveLanguage == 3)
        eID = KBD_LAYOUT_ARABIC;

    if (NULL != m_pkKeyboard)
        m_pkKeyboard->LoadLayout(eID);
}
