#include "DemoData.h"

#include "GUI.h"

#include "GUITimer.h"
#include "GUIDataPool.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

DemoData::DemoData() :
    m_pkChart(NULL),
    m_eChartDatapool(DUMMY_DATAPOOLRESOURCE),
    m_pkGraph(NULL),
    m_pkFunction1(NULL),
    m_pkFunction2(NULL),
    m_pkFunction3(NULL),
    m_pkPlot(NULL),
    m_bAutoRefresh(false),
    m_uiRefreshInterval(0),
    m_pkRefreshSlider(NULL)
{
}

DemoData::~DemoData()
{
    DeInit();
}

void DemoData::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_DATA));
    if (NULL != m_pkDialog)
    {
        m_eChartDatapool = CHART_DATAPOOL;
        m_pkChart = auto_cast<CGUIChart*>(m_pkDialog->GetObjectByID(OBJ_CHART));
        if (NULL != m_pkChart)
        {
            m_pkChart->SetRangeX(20, 30);
            m_pkChart->SetRangeY(50, 90);
            m_pkChart->JumpToDataPoint(0);
        }

        m_pkGraph = auto_cast<CGUIGraph*>(m_pkDialog->GetObjectByID(OBJ_GRAPH));
        if (NULL != m_pkGraph)
        {
            m_pkFunction1 = new TestFunction1();
            m_pkFunction2 = new TestFunction2();
            m_pkFunction3 = new TestFunction3();
            m_pkGraph->SetFunction(0, m_pkFunction1);
            m_pkGraph->SetFunction(1, m_pkFunction2);
            m_pkGraph->SetFunction(2, m_pkFunction3);
        }

        m_pkPlot = auto_cast<CGUIPlot*>(m_pkDialog->GetObjectByID(OBJ_PLOT));
        if (NULL != m_pkPlot)
        {
            m_bAutoRefresh = false;
            m_uiRefreshInterval = 250;
            m_pkPlot->SetRefresh(m_bAutoRefresh, m_uiRefreshInterval);
        }

        m_pkRefreshSlider = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_HORIZONTAL));
        if (NULL != m_pkRefreshSlider)
            m_pkRefreshSlider->AddValueObserver(this);

        GETTIMER.AddAnimationCallback(500, this);
    }
}

void DemoData::DeInit()
{
    // detach from graph
    if (NULL != m_pkGraph)
    {
        m_pkGraph->SetFunction(0, NULL);
        m_pkGraph->SetFunction(1, NULL);
        m_pkGraph->SetFunction(2, NULL);
    }

    delete m_pkFunction1;
    delete m_pkFunction2;
    delete m_pkFunction3;

    GETTIMER.RemoveAnimationCallback(this);
}

void DemoData::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (NULL != pkUpdatedObject)
    {
        if (pkUpdatedObject->GetID() == SLIDER_HORIZONTAL)
        {
            if (NULL != m_pkPlot)
            {
                m_uiRefreshInterval = kObservedValue.ToUInt();
                m_pkPlot->SetRefresh(m_bAutoRefresh, m_uiRefreshInterval);
            }
        }
    }
}

void DemoData::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "ZoomIn")
    {
        if (kParam == "X")
        {
            if (NULL != m_pkChart)
                m_pkChart->ZoomInX();
        }
        else if (kParam == "Y")
        {
            if (NULL != m_pkChart)
                m_pkChart->ZoomInY();
        }
    }
    else if (kAPI == "ZoomOut")
    {
        if (kParam == "X")
        {
            if (NULL != m_pkChart)
                m_pkChart->ZoomOutX();
        }
        else if (kParam == "Y")
        {
            if (NULL != m_pkChart)
                m_pkChart->ZoomOutY();
        }
    }
    else if (kAPI == "ChartType")
    {
        if (NULL != m_pkChart)
        {
            CGUIChart::DataRepresentation_t eType = m_pkChart->GetDataRepresentation();
            switch (eType)
            {
                case CGUIChart::POINTS:
                    eType = CGUIChart::POINTS_AND_LINES;
                    break;

                case CGUIChart::POINTS_AND_LINES:
                    eType = CGUIChart::LINES;

                case CGUIChart::LINES:
                    eType = CGUIChart::BARS;
                    break;

                case CGUIChart::BARS:
                    eType = CGUIChart::STACKED_LINES;
                    break;

                case CGUIChart::STACKED_LINES:
                    eType = CGUIChart::STACKED_BARS;
                    break;

                case CGUIChart::STACKED_BARS:
                    eType = CGUIChart::POINTS;
                    break;

                default:
                    eType = CGUIChart::POINTS;
                    break;
            }

            m_pkChart->SetDataRepresentation(eType);
        }
    }
    else if (kAPI == "SelectData")
    {
        if (NULL != m_pkChart)
            m_pkChart->SetShowBarData(!m_pkChart->GetShowBarData());
    }

    if (kAPI == "ZoomInGraph")
    {
        if (NULL != m_pkGraph)
        {
            eC_Value vScalingX;
            eC_Value vScalingY;
            m_pkGraph->GetScaling(vScalingX, vScalingY);

            if (kParam == "X")
                vScalingX = eC_Div(vScalingX, eC_FromInt(2));
            else if (kParam == "Y")
                vScalingY = eC_Div(vScalingY, eC_FromInt(2));
            m_pkGraph->SetScaling(vScalingX, vScalingY);
        }
    }
    else if (kAPI == "ZoomOutGraph")
    {
        if (NULL != m_pkGraph)
        {
            eC_Value vScalingX;
            eC_Value vScalingY;
            m_pkGraph->GetScaling(vScalingX, vScalingY);

            if (kParam == "X")
                vScalingX = eC_Mul(vScalingX, eC_FromInt(2));
            else if (kParam == "Y")
                vScalingY = eC_Mul(vScalingY, eC_FromInt(2));
            m_pkGraph->SetScaling(vScalingX, vScalingY);
        }
    }

    if (kAPI == "ZoomInPlot")
    {
        if (NULL != m_pkPlot)
        {
            eC_Value vScalingX;
            eC_Value vScalingY;
            m_pkPlot->GetScaling(vScalingX, vScalingY);

            if (kParam == "X")
                vScalingX = eC_Div(vScalingX, eC_FromInt(2));
            else if (kParam == "Y")
                vScalingY = eC_Div(vScalingY, eC_FromInt(2));
            m_pkPlot->SetScaling(vScalingX, vScalingY);
        }
    }
    else if (kAPI == "ZoomOutPlot")
    {
        if (NULL != m_pkPlot)
        {
            eC_Value vScalingX;
            eC_Value vScalingY;
            m_pkPlot->GetScaling(vScalingX, vScalingY);

            if (kParam == "X")
                vScalingX = eC_Mul(vScalingX, eC_FromInt(2));
            else if (kParam == "Y")
                vScalingY = eC_Mul(vScalingY, eC_FromInt(2));
            m_pkPlot->SetScaling(vScalingX, vScalingY);
        }
    }
    else if (kAPI == "AutoRefresh")
    {
        if (NULL != m_pkPlot)
        {
            m_bAutoRefresh = !m_bAutoRefresh;
            m_pkPlot->SetRefresh(m_bAutoRefresh, m_uiRefreshInterval);
        }
    }
}

void DemoData::DoAnimate(const eC_Value &vTimes)
{
    static eC_Float fPhase1 = 0.0f;
    static eC_Float fPhase2 = 90.0f;

    if (NULL != m_pkPlot)
    {
        eC_Float fData;
        fData = (eC_Float)(eC_Sin(fPhase1) * 10.0f);
        m_pkPlot->AddData(0, fData);
        fPhase1 += 0.25f;

        fData = (eC_Float)(eC_Cos(fPhase2) * 10.0f);
        m_pkPlot->AddData(1, fData);
        fPhase2 += 0.25f;

        m_pkPlot->Refresh();
    }
}
