#include "DemoControls.h"

#include "GUI.h"
#include "GUIText.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

ObsvProgressImg::ObsvProgressImg(CGUIRadialProgressBar* pkProgressBar, CGUIImage* pkImage, CGUIBaseSlider* pkSlider) :
    m_pkTargetObject(pkProgressBar),
    m_pkTargetImageObject(pkImage)
{
    if (pkSlider)
    {
        pkSlider->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("SLIDER_OBSERVER: Slider is missing\n"));
    }
}

void ObsvProgressImg::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (m_pkTargetObject)
    {
        eC_Value newVal = kObservedValue.ToValue();

        /*Change the value for the progress bar*/
        if (m_pkTargetObject)
        {
            m_pkTargetObject->SetValue(newVal);
            m_pkTargetObject->InvalidateArea();
        }

        /*Depending on the value of the slider, the image will have a different image*/
        if (m_pkTargetImageObject)
        {
            if (newVal < 75)
            {
                m_pkTargetImageObject->SetImage(IMG_ROUND_BUTTON_STD_GRAY);
            }
            else if (newVal > 225)
            {
                m_pkTargetImageObject->SetImage(IMG_ROUND_BUTTON_HOVER_BLUE);
            }
            else
            {
                m_pkTargetImageObject->SetImage(IMG_ROUND_BUTTON_PRESSED_GREEN);
            }
            m_pkTargetImageObject->InvalidateArea();
        }
        else
        {
            GUILOG(GUI_TRACE_ERROR, eC_String("SLIDER_OBSERVER: IMAGE COULD NOT BE FOUND\n"));
        }
    }
}

ObsvGeometry::ObsvGeometry(CGUIBaseSlider* pkSliderR, CGUIBaseSlider* pkSliderG, CGUIBaseSlider* pkSliderB, CGUIGeometryObject* pkGeometry) :
    m_pkGeometry(pkGeometry),
    m_pkSliderRed(pkSliderR),
    m_pkSliderGreen(pkSliderG),
    m_pkSliderBlue(pkSliderB)
{
    if (NULL != m_pkSliderRed)
    {
        m_pkSliderRed->AddValueObserver(this);
    }

    if (NULL != m_pkSliderGreen)
    {
        m_pkSliderGreen->AddValueObserver(this);
    }

    if (NULL != m_pkSliderBlue)
    {
        m_pkSliderBlue->AddValueObserver(this);
    }

    OnNotification(0, m_pkSliderRed, 0, 0);
    OnNotification(0, m_pkSliderGreen, 0, 0);
    OnNotification(0, m_pkSliderBlue, 0, 0);
}

void ObsvGeometry::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (
        (NULL != pkUpdatedObject) &&
        (NULL != m_pkGeometry)
        )
    {
        eC_UInt uiColor = m_pkGeometry->GetColor();
        if (pkUpdatedObject == m_pkSliderRed)
        {
            eC_UByte ubSlider = static_cast<eC_UByte>(eC_ToInt(m_pkSliderRed->GetRange().GetValue()));
            uiColor = (uiColor & 0xff00ffff) + (ubSlider << 16);
            m_pkGeometry->SetColor(uiColor);
        }
        else if (pkUpdatedObject == m_pkSliderGreen)
        {
            eC_UByte ubSlider = static_cast<eC_UByte>(eC_ToInt(m_pkSliderGreen->GetRange().GetValue()));
            uiColor = (uiColor & 0xffff00ff) + (ubSlider << 8);
            m_pkGeometry->SetColor(uiColor);
        }
        else if (pkUpdatedObject == m_pkSliderBlue)
        {
            eC_UByte ubSlider = static_cast<eC_UByte>(eC_ToInt(m_pkSliderBlue->GetRange().GetValue()));
            uiColor = (uiColor & 0xffffff00) + (ubSlider);
            m_pkGeometry->SetColor(uiColor);
        }
        m_pkGeometry->InvalidateArea();
    }
}

DemoControls::DemoControls() :
    DemoBase(),
    m_pkProgressImg(NULL),
    m_pkGeometryObserver(NULL),
    m_pkSliderRed(NULL),
    m_pkSliderGreen(NULL),
    m_pkSliderBlue(NULL),
    m_pkGeometry(NULL),
    m_pkRangeSlider(NULL),
    m_pkRangeText(NULL),
    m_pkSegmentBar(NULL)
{
}

DemoControls::~DemoControls()
{
    DeInit();
}

void DemoControls::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (pkUpdatedObject == m_pkRangeSlider)
    {
        if ((NULL != m_pkRangeSlider) && (NULL != m_pkRangeText))
        {
            eC_Int iValue1 = m_pkRangeSlider->GetRange().GetValue();
            eC_Int iValue2 = m_pkRangeSlider->GetRange2().GetValue();
            m_pkRangeText->GetLabel()->SetTextString(eC_String(iValue1) + " - " + eC_String(iValue2));
            m_pkRangeText->InvalidateArea();
        }
    }
}

void DemoControls::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_CONTROLS));
    if (NULL != m_pkDialog)
    {
        CGUIRadialProgressBar* pkProgressBar = auto_cast<CGUIRadialProgressBar*>(m_pkDialog->GetObjectByID(PROGRESS_HORIZONTAL));
        CGUIImage* pkImage = auto_cast<CGUIImage*>(m_pkDialog->GetObjectByID(IMG_CHANGE));
        CGUIBaseSlider* pkSlider = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_HORIZONTAL));
        m_pkProgressImg = new ObsvProgressImg(pkProgressBar, pkImage, pkSlider);

        if (NULL != pkSlider)
            pkSlider->SetValue(CGUIValue(50));

        m_pkGeometry = auto_cast<CGUIGeometryObject*>(m_pkDialog->GetObjectByID(GEO_COLOR));
        m_pkSliderRed = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_R));
        m_pkSliderGreen = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_G));
        m_pkSliderBlue = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_B));

        if (NULL != m_pkGeometry)
        {
            m_pkGeometryObserver = new ObsvGeometry(m_pkSliderRed, m_pkSliderGreen, m_pkSliderBlue, m_pkGeometry);
        }

        m_pkRangeSlider = auto_cast<CGUIRangeSlider*>(m_pkDialog->GetObjectByID(OBJ_RANGESLIDER));
        m_pkRangeText = auto_cast<CGUIBaseTextField*>(m_pkDialog->GetObjectByID(OBJ_RANGE_TEXT));

        if ((NULL != m_pkRangeSlider) && (NULL != m_pkRangeText))
        {
            OnNotification(CGUIValue(0), m_pkRangeSlider);

            m_pkRangeSlider->AddValueObserver(this);
        }

        m_pkSegmentBar = auto_cast<CGUISegmentBar*>(m_pkDialog->GetObjectByID(OBJ_SEGMENT_BAR));
    }
}

void DemoControls::DeInit()
{
    delete m_pkProgressImg;
    m_pkProgressImg = NULL;

    delete m_pkGeometryObserver;
    m_pkGeometryObserver = NULL;
}

void DemoControls::SetColor(const eC_UInt& uiColor)
{
    if (NULL != m_pkSliderRed)
    {
        m_pkSliderRed->SetValue((uiColor & 0x00ff0000) >> 16);
    }
    if (NULL != m_pkSliderGreen)
    {
        m_pkSliderGreen->SetValue((uiColor & 0x0000ff00) >> 8);
    }
    if (NULL != m_pkSliderBlue)
    {
        m_pkSliderBlue->SetValue(uiColor & 0x000000ff);
    }
}

eC_UInt DemoControls::GetColor()
{
    if (NULL != m_pkGeometry)
        return m_pkGeometry->GetColor();
    else
        return 0;
}

void DemoControls::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "DecSegment")
    {
        if (NULL != m_pkSegmentBar)
        {
            eC_Int iValue = m_pkSegmentBar->GetRange().GetValue();
            if (iValue > 0)
            {
                --iValue;
                m_pkSegmentBar->SetValue(iValue);
            }
        }
    }
    else if (kAPI == "IncSegment")
    {
        if (NULL != m_pkSegmentBar)
        {
            eC_Int iValue = m_pkSegmentBar->GetRange().GetValue();
            if (iValue < m_pkSegmentBar->GetRange().GetMaxValue())
            {
                ++iValue;
                m_pkSegmentBar->SetValue(iValue);
            }
        }
    }
}
