#include "DemoContainer.h"

#include "GUI.h"
#include "GUIResourceManager.h"
#include "GUIObserver.h"
#include "GUIImage.h"
#include "GUIText.h"
#include "GUITextField.h"
#include "GUIButton.h"
#include "GUITimer.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

ObsvSliderTilt::ObsvSliderTilt(CGUICarousel* pkCarousel, CGUIBaseSlider* pkSlider) :
    m_pkTargetObject(pkCarousel)
{
    if (pkSlider)
    {
        pkSlider->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("TILT_OBSERVER: Slider is missing\n"));
    }
}

void ObsvSliderTilt::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (m_pkTargetObject)
    {
        /*Get the value of the left slider and set it for the tilt-angle*/
        eC_Value newVal = kObservedValue.ToValue();
        m_pkTargetObject->SetTiltAngle(newVal);
        m_pkTargetObject->InvalidateArea();
    }
}

ObsvSliderRadius::ObsvSliderRadius(CGUICarousel* pkCarousel, CGUIBaseSlider* pkSlider) :
    m_pkTargetObject(pkCarousel)
{
    if (pkSlider)
    {
        pkSlider->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("RADIUS_OBSERVER: Slider is missing\n"));
    }
}

void ObsvSliderRadius::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (m_pkTargetObject)
    {
        /*get the value of the right slider and set it for the radius*/
        eC_Value newVal = kObservedValue.ToValue();
        m_pkTargetObject->SetRadius(newVal);
        m_pkTargetObject->InvalidateArea();
    }
}

ObsvSliderCount::ObsvSliderCount(CGUICarousel* pkCarousel, CGUIBaseSlider* pkSlider) :
    m_pkTargetObject(pkCarousel),
    m_uiCount(5)
{
    if (pkSlider != NULL)
    {
        pkSlider->AddValueObserver(this);
    }
    else
    {
        GUILOG(GUI_TRACE_ERROR, eC_String("COUNT_OBSERVER: Slider is missing\n"));
    }

    m_eImages[0] = IMG_CAROUSELIMG;
    m_eImages[1] = IMG_CAROUSELIMG2;
    m_eImages[2] = IMG_CAROUSELIMG3;
    m_eImages[3] = IMG_CAROUSELIMG4;
    m_eImages[4] = IMG_CAROUSELIMG5;
}

void ObsvSliderCount::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (m_pkTargetObject != NULL)
    {
        eC_Value newVal = kObservedValue.ToValue();
        eC_UInt numOfChild = m_pkTargetObject->GetNumberOfChildren();
        if (newVal < numOfChild)
        {
            for (; m_uiCount >= newVal; m_uiCount--)
            {
                // Remove the Object from the carousel
                CGUIObject* pkObject = m_pkTargetObject->GetChild(m_uiCount);
                if (NULL != pkObject)
                {
                    m_pkTargetObject->RemoveObject(pkObject);
                    delete pkObject;
                }
                m_pkTargetObject->InvalidateArea();
            }
        }
        else
        {
            eC_UByte ubAlpha = m_pkTargetObject->GetChild(0)->GetAlpha();
            eC_UInt tmp = m_uiCount;
            for (; m_uiCount < tmp + newVal - numOfChild; m_uiCount++)
            {
                // Add another object to the carousel get first child as template
                eC_Value vTargetWidth, vTargetHeight;
                m_pkTargetObject->GetOriginalSize(0, vTargetWidth, vTargetHeight);

                eC_String kButtonText = "";
                eC_UInt uiNinepatch = 0;

                // check for simple image-sets
                if ((GETRESMANAGER.GetImagesFilename() == "LightSimple") || (GETRESMANAGER.GetImagesFilename() == "DarkSimple"))
                {
                    kButtonText = "1";
                    uiNinepatch = 5;
                }

                CGUIButton* pkButton = new CGUIButton(m_pkTargetObject, 0, 0, vTargetWidth, vTargetHeight, kButtonText, NULL);
                if (NULL != pkButton)
                {
                    if (kButtonText != "")
                        pkButton->SetLabel(eC_String(m_uiCount + 1));
                    if (NULL != pkButton->GetLabel())
                    {
                        pkButton->GetLabel()->SetFont(HEADER_FNT);
                        pkButton->GetLabel()->SetTextColor(PROP_TEXT_COLOR_DEFAULT, PROP_TEXT_COLOR_DEFAULT, PROP_TEXT_COLOR_DEFAULT, PROP_TEXT_COLOR_DEFAULT);
                        pkButton->GetNinePatch().Assign(uiNinepatch, uiNinepatch, uiNinepatch, uiNinepatch);
                    }

                    ImageResource_t eImage = m_eImages[(m_uiCount + 1) % CAROUSEL_ICON_COUNT];
                    pkButton->SetImages(eImage, eImage, eImage, eImage, eImage);
                    pkButton->SetAlpha(ubAlpha);
                    m_pkTargetObject->AddObject(pkButton);
                }
                m_pkTargetObject->InvalidateArea();
            }
        }
    }
}

DemoContainer::DemoContainer() :
    m_pkObserverTilt(NULL),
    m_pkObserverRadius(NULL),
    m_pkObserverNumber(NULL),
    m_pkCarousel(NULL),
    m_bFlowModeActive(false),
    m_pkPageContainer(NULL),
    m_pkWheelContainer(NULL)
{
}

DemoContainer::~DemoContainer()
{
    DeInit();
}

/*Get every needed element of the dialog and assign it to the observers*/
void DemoContainer::Init()
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_CONTAINER));

    if (NULL != m_pkDialog)
    {
        // reset flowmode on init
        m_bFlowModeActive = false;

        m_pkCarousel = auto_cast<CGUICarousel*>(m_pkDialog->GetObjectByID(CAROUSEL_TEST));
        CGUIBaseSlider* pkSliderTilt = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_TILT));
        CGUIBaseSlider* pkSliderRadius = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(SLIDER_RADIUS));
        CGUIBaseSlider* pkSliderNumber = auto_cast<CGUIBaseSlider*>(m_pkDialog->GetObjectByID(NUMBER_OF_ELEMENTS));

        if (NULL != m_pkCarousel)
        {
            // check for simple image-sets
            if ((GETRESMANAGER.GetImagesFilename() == "LightSimple") || (GETRESMANAGER.GetImagesFilename() == "DarkSimple"))
            {
                eC_Value vTargetWidth, vTargetHeight;
                m_pkCarousel->GetOriginalSize(0, vTargetWidth, vTargetHeight);

                for (eC_UInt uiIndex = 0; uiIndex < m_pkCarousel->GetNumberOfChildren(); ++uiIndex)
                {
                    CGUIButton* pkButton = auto_cast<CGUIButton*>(m_pkCarousel->GetChild(uiIndex));
                    if (NULL != pkButton)
                    {
                        pkButton->SetLabel(eC_String(uiIndex + 1));
                        pkButton->GetLabel()->SetTextWidth(pkButton->GetWidth());
                        pkButton->GetLabel()->SetTextHeight(pkButton->GetHeight());
                        pkButton->GetLabel()->SetAligned(CGUIText::V_CENTERED, CGUIText::H_CENTERED);
                        pkButton->GetNinePatch().Assign(5, 5, 5, 5);
                    }
                }
            }

            m_pkObserverTilt = new ObsvSliderTilt(m_pkCarousel, pkSliderTilt);
            m_pkObserverRadius = new ObsvSliderRadius(m_pkCarousel, pkSliderRadius);
            m_pkObserverNumber = new ObsvSliderCount(m_pkCarousel, pkSliderNumber);
        }

        m_pkPageContainer = auto_cast<CGUIPageContainer*>(m_pkDialog->GetObjectByID(OBJ_PAGECONTAINER));
        m_pkWheelContainer = auto_cast<CGUIWheelContainer*>(m_pkDialog->GetObjectByID(OBJ_WHEELCONTAINER));
    }
}

void DemoContainer::DeInit()
{
    delete m_pkObserverTilt;
    m_pkObserverTilt = NULL;
    delete m_pkObserverRadius;
    m_pkObserverRadius = NULL;
    delete m_pkObserverNumber;
    m_pkObserverNumber = NULL;

    GETTIMER.RemoveAnimationCallback(this);
}

void DemoContainer::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "ToggleFlow")
    {
        ChangeCarouselMode();
    }
    else if (kAPI == "ToggleDrag")
    {
        if (NULL != m_pkPageContainer)
        {
            eC_Bool bDragActive = m_pkPageContainer->GetDragActive();
            m_pkPageContainer->SetDragActive(!bDragActive);
        }
    }
    else if (kAPI == "ToggleCyclic")
    {
        if (NULL != m_pkWheelContainer)
        {
            eC_Bool bCyclic = m_pkWheelContainer->IsCyclic();
            m_pkWheelContainer->SetCyclic(!bCyclic);
        }
    }
}

void DemoContainer::ChangeCarouselMode()
{
    if (NULL != m_pkCarousel)
    {
        m_bFlowModeActive = !m_bFlowModeActive;
        CGUIObject* pSelectedObj = m_pkCarousel->GetSelectedObject();
        m_pkCarousel->EnableFlowMode(m_bFlowModeActive);

        if (m_bFlowModeActive)
        {
            m_pkCarousel->SetPerspectiveFactor(eC_FromFloat(1.2));
        }
        else
        {
            m_pkCarousel->SetPerspectiveFactor(eC_FromFloat(0.5));
        }

        if (pSelectedObj)
        {
            m_pkCarousel->JumpToObject(pSelectedObj);
        }
        m_pkCarousel->InvalidateArea();
    }
}
