#include "DemoAdvanced.h"

#include "MyGUI_SR.h"
#include "GUIDataPool.h"

/*Always include last*/
#include "GUIMemLeakWatcher.h"

#define USE_SMOOTH_ANIMATION 1

CalendarObserver::CalendarObserver(CGUIBaseTextField* pkTargetObject) :
    m_pkTargetObject(pkTargetObject)
{
}

void CalendarObserver::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (NULL != m_pkTargetObject)
    {
        m_pkTargetObject->GetLabel()->SetTextString(kObservedValue.ToString());
        m_pkTargetObject->InvalidateArea();
    }
}

ClockObserver::ClockObserver(CGUIBaseTextField* pkTargetObject) :
    m_pkTargetObject(pkTargetObject)
{
}

void ClockObserver::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (NULL != m_pkTargetObject)
    {
        m_pkTargetObject->GetLabel()->SetTextString(kObservedValue.ToString());
        m_pkTargetObject->InvalidateArea();
    }
}

KnobObserver::KnobObserver(
    CGUIBaseTextField* pkTargetObject,
    CGUIKnob* pkKnob,
    CGUICircularSlider* pkCircularSlider) :
    m_pkTargetObject(pkTargetObject),
    m_pkKnob(pkKnob),
    m_pkCircularSlider(pkCircularSlider)
{
}

void KnobObserver::OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX, const eC_UInt uiY)
{
    if (
        (NULL != m_pkTargetObject) &&
        (NULL != m_pkKnob) &&
        (NULL != m_pkCircularSlider)
        )
    {
        if (pkUpdatedObject == m_pkKnob)
        {
            // remove observer and re-attach to prevent recursion
            m_pkCircularSlider->RemoveValueObserver(this);
            m_pkCircularSlider->SetValue(kObservedValue.ToInt());
            m_pkCircularSlider->AddValueObserver(this);
        }
        else if (pkUpdatedObject == m_pkCircularSlider)
        {
            // remove observer and re-attach to prevent recursion
            m_pkKnob->RemoveValueObserver(this);
            m_pkKnob->SetValue(kObservedValue.ToInt());
            m_pkKnob->AddValueObserver(this);
        }

        // update textfield
        m_pkTargetObject->GetLabel()->SetTextString(kObservedValue.ToString());
        m_pkTargetObject->InvalidateArea();
    }
}

GaugeAnimation::GaugeAnimation(CGUIGauge* pkGauge, eC_Int iTargetValue) :
    CGUIAnimation(pkGauge, 2000, 100, false),
    m_pkGauge(pkGauge),
    m_iStartValue(0),
    m_iTargetValue(iTargetValue)
{
    if (NULL != m_pkGauge)
        m_iStartValue = m_pkGauge->GetRange().GetValue();
}

GaugeAnimation::~GaugeAnimation()
{
    m_pkGauge = NULL;
}

void GaugeAnimation::ApplyAnimation(eC_UInt uiElapsedTime)
{
    if (NULL != m_pkGauge)
    {
        CGUIEasing kEasing;
        eC_Int iValue = eC_ToInt(kEasing(CGUIEasing::EASE_LINEAR, eC_FromInt(uiElapsedTime), eC_FromInt(m_iStartValue), eC_FromInt(m_iTargetValue - m_iStartValue), eC_FromInt(2000)));
        m_pkGauge->SetValue(CGUIValue(iValue));
    }
}

DemoAdvanced::DemoAdvanced(
    CGUIEasing::EasingType_t eEasingUp,
    CGUIEasing::EasingType_t eEasingDown) :
    m_pkCalendar(NULL),
    m_pkCalendarTextField(NULL),
    m_pkCalendarObserver(NULL),
    m_pkClock(NULL),
    m_pkClockTextField(NULL),
    m_pkClockObserver(NULL),
    m_pkKnob(NULL),
    m_pkCircularSlider(NULL),
    m_pkKnobTextField(NULL),
    m_pkKnobObserver(NULL),
    m_vWheelValueFromDatapool(eC_FromInt(0)),
    m_vValueBuffer(eC_FromInt(0)),
    m_pkMainGauge(NULL),
    m_pkWheelControl(NULL),
    m_eEasingUp(eEasingUp),
    m_eEasingDown(eEasingDown),
    m_pkGaugeAnimation(NULL)
{
}

DemoAdvanced::~DemoAdvanced()
{
    DeInit();
}

void DemoAdvanced::Init(const eC_UInt& uiTime)
{
    m_pkDialog = auto_cast<CGUICompositeObject*>(GETGUI.GetObjectByID(DLG_ADVANCED));
    if (NULL != m_pkDialog)
    {
        m_pkCalendar = auto_cast<CGUICalendar*>(m_pkDialog->GetObjectByID(OBJ_CALENDAR));
        m_pkCalendarTextField = auto_cast<CGUIBaseTextField*>(m_pkDialog->GetObjectByID(OBJ_CALENDAR_TEXT));

        if ((NULL != m_pkCalendar) && (NULL != m_pkCalendarTextField))
        {
            m_pkCalendarObserver = new CalendarObserver(m_pkCalendarTextField);
            m_pkCalendar->AddValueObserver(m_pkCalendarObserver);
            m_pkCalendar->SetDate(17, 4, 2021);
        }

        m_pkClock = auto_cast<CGUIClock*>(m_pkDialog->GetObjectByID(OBJ_CLOCK));
        m_pkClockTextField = auto_cast<CGUIBaseTextField*>(m_pkDialog->GetObjectByID(OBJ_CLOCK_TEXT));

        if ((NULL != m_pkClock) && (NULL != m_pkClockTextField))
        {
            m_pkClockObserver = new ClockObserver(m_pkClockTextField);
            m_pkClock->AddValueObserver(m_pkClockObserver);
            m_pkClock->SetTimeInSeconds(uiTime);
        }

        m_pkKnob = auto_cast<CGUIKnob*>(m_pkDialog->GetObjectByID(OBJ_KNOB));
        m_pkCircularSlider = auto_cast<CGUICircularSlider*>(m_pkDialog->GetObjectByID(OBJ_CIRC_SLIDER));
        m_pkKnobTextField = auto_cast<CGUIBaseTextField*>(m_pkDialog->GetObjectByID(OBJ_CIRC_TEXT));

        if (
            (NULL != m_pkKnob) &&
            (NULL != m_pkKnobTextField) &&
            (NULL != m_pkCircularSlider)
            )
        {
            m_pkKnobObserver = new KnobObserver(m_pkKnobTextField, m_pkKnob, m_pkCircularSlider);
            m_pkKnob->AddValueObserver(m_pkKnobObserver);
            m_pkCircularSlider->AddValueObserver(m_pkKnobObserver);

            m_pkKnob->SetValue(-5);

#if defined(eC_TARGET_ENV_RA6M3) || defined(GFX_USE_BLU)
            // use primitives for the knob
            m_pkKnob->SetImages(IMG_KNOB_BACKGROUND, DUMMY_IMAGE);
#endif
        }

        m_pkMainGauge = dynamic_cast<CGUIGauge*>(m_pkDialog->GetObjectByID(GAUGE_ANIMATED));
#if defined(eC_TARGET_ENV_RA6M3) || defined(GFX_USE_BLU)
        // use pritmives for the gauge
        if (NULL != m_pkMainGauge)
            m_pkMainGauge->SetNeedleImage(DUMMY_IMAGE);
#endif
        m_pkWheelControl = dynamic_cast<CGUIWheel*>(m_pkDialog->GetObjectByID(VERTICAL_WHEEL));
    }
}

void DemoAdvanced::DeInit()
{
    delete m_pkCalendarObserver;
    m_pkCalendarObserver = NULL;

    delete m_pkClockObserver;
    m_pkClockObserver = NULL;

    delete m_pkKnobObserver;
    m_pkKnobObserver = NULL;
}

eC_UInt DemoAdvanced::GetTime() const
{
    if (m_pkClock)
        return m_pkClock->GetTimeInSeconds();
    else
        return 0;
}

void DemoAdvanced::SetLanguage(const eC_Int& iActiveLanguage)
{
    if (m_pkCalendar)
    {
        switch (iActiveLanguage)
        {
            case 1:
                m_pkCalendar->SetDayText(0, "So");
                m_pkCalendar->SetDayText(1, "Mo");
                m_pkCalendar->SetDayText(2, "Di");
                m_pkCalendar->SetDayText(3, "Mi");
                m_pkCalendar->SetDayText(4, "Do");
                m_pkCalendar->SetDayText(5, "Fr");
                m_pkCalendar->SetDayText(6, "Sa");
                m_pkCalendar->SetMonthText(0, "Januar");
                m_pkCalendar->SetMonthText(1, "Februar");
                m_pkCalendar->SetMonthText(2, "Mrz");
                m_pkCalendar->SetMonthText(3, "April");
                m_pkCalendar->SetMonthText(4, "Mai");
                m_pkCalendar->SetMonthText(5, "Juni");
                m_pkCalendar->SetMonthText(6, "Juli");
                m_pkCalendar->SetMonthText(7, "August");
                m_pkCalendar->SetMonthText(8, "September");
                m_pkCalendar->SetMonthText(9, "Oktober");
                m_pkCalendar->SetMonthText(10, "November");
                m_pkCalendar->SetMonthText(11, "Dezember");
                break;

            case 2:
                m_pkCalendar->SetDayText(0, eC_String("\xD0\x92\xD0\xA1", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(1, eC_String("\xD0\x9F\xD0\x9E", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(2, eC_String("\xD0\x92\xD0\xA2", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(3, eC_String("\xD0\xA1\xD0\xA0", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(4, eC_String("\xD0\xA7\xD0\xA2", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(5, eC_String("\xD0\x9F\xD0\xA2", 0, eC_String::eUTF8));
                m_pkCalendar->SetDayText(6, eC_String("\xD0\xA1\xD0\x91", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(0, eC_String("\xD0\xAF\xD0\xBD\xD0\xB2\xD0\xB0\xD1\x80\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(1, eC_String("\xD0\xA4\xD0\xB5\xD0\xB2\xD1\x80\xD0\xB0\xD0\xBB\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(2, eC_String("\xD0\x9C\xD0\xB0\xD1\x80\xD1\x82", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(3, eC_String("\xD0\x90\xD0\xBF\xD1\x80\xD0\xB5\xD0\xBB\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(4, eC_String("\xD0\x9C\xD0\xB0\xD0\xB9", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(5, eC_String("\xD0\x98\xD1\x8E\xD0\xBD\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(6, eC_String("\xD0\x98\xD1\x8E\xD0\xBB\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(7, eC_String("\xD0\x90\xD0\xB2\xD0\xB3\xD1\x83\xD1\x81\xD1\x82", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(8, eC_String("\xD0\xA1\xD0\xB5\xD0\xBD\xD1\x82\xD1\x8F\xD0\xB1\xD1\x80\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(9, eC_String("\xD0\x9E\xD0\xBA\xD1\x82\xD1\x8F\xD0\xB1\xD1\x80\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(10, eC_String("\xD0\x9D\xD0\xBE\xD1\x8F\xD0\xB1\xD1\x80\xD1\x8C", 0, eC_String::eUTF8));
                m_pkCalendar->SetMonthText(11, eC_String("\xD0\x94\xD0\xB5\xD0\xBA\xD0\xB0\xD0\xB1\xD1\x80\xD1\x8C", 0, eC_String::eUTF8));
                break;

            default:
                m_pkCalendar->SetDayText(0, "Su");
                m_pkCalendar->SetDayText(1, "Mo");
                m_pkCalendar->SetDayText(2, "Tu");
                m_pkCalendar->SetDayText(3, "We");
                m_pkCalendar->SetDayText(4, "Th");
                m_pkCalendar->SetDayText(5, "Fr");
                m_pkCalendar->SetDayText(6, "Sa");
                m_pkCalendar->SetMonthText(0, "January");
                m_pkCalendar->SetMonthText(1, "February");
                m_pkCalendar->SetMonthText(2, "March");
                m_pkCalendar->SetMonthText(3, "April");
                m_pkCalendar->SetMonthText(4, "May");
                m_pkCalendar->SetMonthText(5, "June");
                m_pkCalendar->SetMonthText(6, "July");
                m_pkCalendar->SetMonthText(7, "August");
                m_pkCalendar->SetMonthText(8, "September");
                m_pkCalendar->SetMonthText(9, "October");
                m_pkCalendar->SetMonthText(10, "November");
                m_pkCalendar->SetMonthText(11, "December");
                break;
        }
    }
}

void DemoAdvanced::HandleCallAPI(const eC_String& kAPI, const eC_String kParam)
{
    if (kAPI == "ToggleKnob")
    {
        if (NULL != m_pkKnob)
        {
            m_pkKnob->SetAxisControl(!m_pkKnob->GetAxisControl());
        }
    }

    // Wheel
    if (kAPI == "HighWheel")
    {
#if USE_SMOOTH_ANIMATION
        if (NULL != m_pkGaugeAnimation)
        {
            m_pkGaugeAnimation->StopAnimation();
            delete m_pkGaugeAnimation;
        }
        m_pkGaugeAnimation = new GaugeAnimation(m_pkMainGauge, 300);
        m_pkGaugeAnimation->StartAnimation();
#else
        if (NULL != m_pkWheelControl)
        {
            m_pkWheelControl->ScrollToAnimated(eC_String("300"));
            m_pkWheelControl->InvalidateArea();
        }
#endif
    }
    else if (kAPI == "MiddleWheel")
    {
#if USE_SMOOTH_ANIMATION
        if (NULL != m_pkGaugeAnimation)
        {
            m_pkGaugeAnimation->StopAnimation();
            delete m_pkGaugeAnimation;
        }
        m_pkGaugeAnimation = new GaugeAnimation(m_pkMainGauge, 150);
        m_pkGaugeAnimation->StartAnimation();
#else
        if (NULL != m_pkWheelControl)
        {
            m_pkWheelControl->ScrollToAnimated(eC_String("150"));
            m_pkWheelControl->InvalidateArea();
        }
#endif
    }
    else if (kAPI == "LowWheel")
    {
#if USE_SMOOTH_ANIMATION
        if (NULL != m_pkGaugeAnimation)
        {
            m_pkGaugeAnimation->StopAnimation();
            delete m_pkGaugeAnimation;
        }
        m_pkGaugeAnimation = new GaugeAnimation(m_pkMainGauge, 0);
        m_pkGaugeAnimation->StartAnimation();
#else
        if (NULL != m_pkWheelControl)
        {
            m_pkWheelControl->ScrollToAnimated(eC_String("0"));
            m_pkWheelControl->InvalidateArea();
        }
#endif
    }
}
