/*
* Copyright (C) TES Electronic Solutions GmbH,
* All Rights Reserved.
* Contact: info@guiliani.de
*
* This file is part of the Guiliani HMI framework
* for the development of graphical user interfaces on embedded systems.
*/

#ifndef _MYGUI_SR_H_
#define _MYGUI_SR_H_

#include "StreamRuntimeGUI.h"
#include "GUIObjectHandleResource.h"

#include "GUIAnimationObserver.h"

#include "DemoSettings.h"

#define GETMYGUI    static_cast<CMyGUI&>(GETGUI)

// forward declarations to minimize dependencies of header-files
class CGUIGeometryObject;
class CGUITextField;
class CGUIBaseSlider;

class DemoAdvanced;
class DemoAnimation;
class DemoContainer;
class DemoControls;
class DemoData;
class DemoKeyboard;
class DemoLayer;

class TextAnimation:  public CGUIAnimatable
{
public:
    TextAnimation(eC_UByte ubStartVal, eC_UByte ubEndVal);
    virtual ~TextAnimation();

    virtual void DoAnimate(const eC_Value &vTimes);

private:
    CGUITextField* m_pkTextField;
    eC_UByte m_ubStartVal;
    eC_UByte m_ubEndVal;
    eC_UInt m_uiCalc;
};

class BoxObserver
    :public CGUIAnimationObserver
{
public:

    BoxObserver(eC_Bool bShow);
    virtual ~BoxObserver();

    virtual void OnStatusChanged(CGUIAnimation::AnimationStatus_t eStatus, CGUIAnimation* pkAnimation);

private:
    eC_Bool m_bShow;
    TextAnimation* m_pkTextAnimation;
};

// Application specific CGUI instance. Implemented by customer.
class CMyGUI : public NStreamRuntime::CStreamRuntimeGUI, public CGUIObserver
{
public:
    enum SelectedMenu_t
    {
        MENU_UNKNOWN,
        MENU_ANIMATION,
        MENU_ADVANCED,
        MENU_CONTAINER,
        MENU_CONTROLS,
        MENU_DATA,
        MENU_KEYBOARD,
        MENU_LAYER,
        MENU_SCRATCHPAD,
        MENU_SETTINGS,
        MENU_COUNT
    };

public:
    CMyGUI(eC_Value x, eC_Value y, eC_Value width, eC_Value height, ObjectHandle_t eID);
    ~CMyGUI();

    /// Example implementation for simple Application <-> GUI communication
    void DoCallAPI(const eC_String& kAPI, const eC_String& kParam);

private:
    /* Method for toggleing between richtext and normal text, just flips the invisibility */
    void EnableRichText();

    /* Enable / Disable NEON optimization*/
    void ToggleOptimizedBlit(const eC_Bool& bToggle);

    /* Enable / Disable FPS display*/
    void ShowFPS(const eC_Bool& bShowFPS);

    /* Enable / Disable Bilinear Blit*/
    void ToggleFilteredBlit(const eC_Bool& bToggle);

    /* Changes the image set between dark and light */
    void ChangeSkin(const eC_Bool& toggle);

    /* Change background color of a dialog */
    void ChangeBackground(const ObjectHandle_t& eObjectID);

    /* Create the field that displays the Info text for the diffrent dialogs */
    void AnimateInfoTxt();

    void SetTransition(const ObjectHandle_t& button);

    void Cleanup();

    void NotifyOfDestruction(const CGUIObject* pDestructedObject);

    void InitDialog(const ObjectHandle_t& eObjectID);

    void ShowDialog(const ObjectHandle_t& eDialogID);

    void SetTransition(const eC_String& kText);

    void ShowGlassPane();

private:
    static const eC_String DIALOG_NAME_MAIN;
    static const eC_String DIALOG_NAME_ADVANCED;
    static const eC_String DIALOG_NAME_ANIMATION;
    static const eC_String DIALOG_NAME_CONTAINER;
    static const eC_String DIALOG_NAME_CONTROLS;
    static const eC_String DIALOG_NAME_DATA;
    static const eC_String DIALOG_NAME_KEYBOARD;
    static const eC_String DIALOG_NAME_LAYER;
    static const eC_String DIALOG_NAME_SCRATCHPAD;
    static const eC_String DIALOG_NAME_SETTINGS;

    DemoAdvanced* m_pkDialogAdvanced;
    DemoAnimation* m_pkDialogAnimation;
    DemoContainer* m_pkDialogContainer;
    DemoControls* m_pkDialogControls;
    DemoData* m_pkDialogData;
    DemoKeyboard* m_pkDialogKeyboard;
    DemoLayer* m_pkDialogLayer;
    DemoSettings* m_pkDialogSettings;

    BoxObserver* m_pkBoxObserver;
    CGUITransitionCmd::TransitionType_t m_eTransitionType;
    ImageResource_t m_eBackgroundImage;
    CGUIEasing::EasingType_t m_eGaugeEasingType;

    SelectedMenu_t m_eSelectedMenu;
    eC_UInt m_uiBackgroundColor;
    DemoSettings::ImageMode_t m_eImageMode;
    DemoSettings::Language_t m_eActiveLanguage;

    CGUIGeometryObject* m_pkGlassPane;
    TextResource_t MenuTexts[9];

    eC_UInt m_uiCurrentTime;
    eC_UInt m_uiCurrentIdleTime;
};

#endif //#ifndef _MYGUI_SR_H_
