#ifndef _DEMOSETTINGS_H_
#define _DEMOSETTINGS_H_

#include "DemoBase.h"

#include "GUIEasing.h"
#include "GUIComboBox.h"
#include "GUIButton.h"
#include "GUICommand.h"
#include "GUIObserver.h"
#include "GUITransitionCmd.h"

#define MAX_EASINGS     4
#define MAX_BACKGROUNDS 4
#define MAX_TRANSITIONS 5

/*Class for the Settings-Dialog, needed for the combobox*/
class DemoSettings : public DemoBase, public CGUIObserver
{
public:
    ///Image Mode
    enum ImageMode_t
    {
        IM_DARK_MODE,
        IM_LIGHT_MODE
    };

    enum Language_t
    {
        ENGLISH,
        GERMAN,
        RUSSIAN,
        ARABIC
    };

    DemoSettings()
    {
    }

    virtual ~DemoSettings();

    virtual void Init();

    virtual void DeInit();

    virtual void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

    void ChangeBackground(const ObjectHandle_t& eObjectID);

    ImageMode_t GetImageMode();

    CGUIEasing::EasingType_t GetEasing() const;

    ImageResource_t GetBackgroundImage() const;

    CGUITransitionCmd::TransitionType_t GetTransition() const;

    void SetEasing(CGUIEasing::EasingType_t eEasing);

    void SetBackgroundImage(ImageResource_t eID);

    void SetBackgroundColor(const eC_UInt& uiBackgroundColor);

    void SetTransition(CGUITransitionCmd::TransitionType_t eTransition);

    eC_Int GetEasingIndex() const;
    eC_Int GetBackgroundIndex() const;
    eC_Int GetTransitionIndex() const;

    eC_Bool IsCheckBoxSelected(const ObjectHandle_t& eObjectID) const;
    void SelectCheckBox(const ObjectHandle_t& eObjectID, const eC_Bool& bSelected, const eC_Bool& bVisible = true) const;

private:
    CGUIEasing::EasingType_t m_kEasings[MAX_EASINGS];
    ImageResource_t m_kBackground[MAX_BACKGROUNDS];
    CGUITransitionCmd::TransitionType_t m_kTransitions[MAX_TRANSITIONS];
    CGUIComboBox* m_pkCombo1;
    CGUIComboBox* m_pkCombo2;
    CGUIComboBox* m_pkCombo3;
    CGUIEasing::EasingType_t m_eGaugeEasing;
    ImageResource_t m_eBackgroundImage;
    CGUITransitionCmd::TransitionType_t m_eTransitionType;
    eC_UInt m_uiBackgroundColor;
    ImageMode_t m_eImageMode;
    Language_t m_eActiveLanguage;
};

#endif
