#ifndef _DEMOLAYER_H_
#define _DEMOLAYER_H_

#include "DemoBase.h"

#include "GUIAnimatable.h"
#include "GUIObserver.h"
#include "GUIBaseSlider.h"
#include "GUICompositeObject.h"

#define MAX_LAYER_ID 5

/*Class for the Carousel-Dialog*/
class DemoLayer : public DemoBase, public CGUIObserver, public CGUIAnimatable
{
public:
    typedef struct
    {
        eC_Bool Active;
        eC_UInt ID;
        eC_Bool Running;
        eC_UInt Width;
        eC_UInt Height;
        eC_UByte BPP;
    } LayerData_t;

public:
    DemoLayer();

    virtual ~DemoLayer();

    virtual void Init();

    virtual void DeInit();

    virtual void OnNotification(const CGUIValue& kObservedValue, const CGUIObject* const pkUpdatedObject, const eC_UInt uiX = 0, const eC_UInt uiY = 0);

    virtual void DoAnimate(const eC_Value &vTimes);

    virtual void HandleCallAPI(const eC_String& kAPI, const eC_String kParam);

private:
    CGUIBaseSlider* m_pkAlphaSlider;
    LayerData_t m_kLayerData[MAX_LAYER_ID];
};

#endif
